/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.config;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.dropwizard.revolver.core.config.HystrixCommandConfig;
import io.dropwizard.revolver.core.config.ThreadPoolGroupConfig;
import io.dropwizard.revolver.core.config.sentinel.SentinelCommandConfig;
import io.dropwizard.revolver.core.model.RevolverExecutorType;
import io.dropwizard.revolver.discovery.EndpointSpec;
import io.dropwizard.revolver.http.auth.AuthConfig;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import io.dropwizard.revolver.http.config.RevolverHttpsServiceConfig;
import io.dropwizard.revolver.splitting.RevolverHttpServiceSplitConfig;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotBlank;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=RevolverHttpServiceConfig.class, name="http"), @JsonSubTypes.Type(value=RevolverHttpsServiceConfig.class, name="https")})
public class RevolverServiceConfig {
    @NotNull
    @Valid
    private EndpointSpec endpoint;
    private boolean authEnabled;
    private AuthConfig auth;
    private boolean secured;
    private String keyStorePath;
    private String keystorePassword;
    private int connectionKeepAliveInMillis = 30000;
    protected ThreadPoolGroupConfig threadPoolGroupConfig;
    @NotNull
    @NotBlank
    private String type;
    @NotNull
    @NotBlank
    private String service;
    private String fallbackAddress;
    private HystrixCommandConfig runtime = new HystrixCommandConfig();
    private SentinelCommandConfig sentinelCommandConfig = new SentinelCommandConfig();
    private Set<RevolverHttpApiConfig> apis;
    private int connectionPoolSize;
    private boolean trackingHeaders;
    private boolean compression;
    private RevolverHttpServiceSplitConfig serviceSplitConfig;
    private RevolverExecutorType revolverExecutorType;

    public RevolverServiceConfig(String type, String service, Set<RevolverHttpApiConfig> apis, int connectionPoolSize, EndpointSpec endpoint, boolean authEnabled, AuthConfig auth, boolean secured, String keystorePassword, String keyStorePath, int connectionKeepAliveInMillis, RevolverHttpServiceSplitConfig serviceSplitConfig, RevolverExecutorType revolverExecutorType, boolean trackingHeaders, boolean compression) {
        this.type = type;
        this.service = service;
        this.apis = apis;
        this.connectionPoolSize = connectionPoolSize;
        this.endpoint = endpoint;
        this.authEnabled = authEnabled;
        this.auth = auth;
        this.secured = secured;
        this.keystorePassword = keystorePassword;
        this.keyStorePath = keyStorePath;
        this.connectionKeepAliveInMillis = connectionKeepAliveInMillis;
        this.serviceSplitConfig = serviceSplitConfig;
        this.revolverExecutorType = revolverExecutorType;
        this.trackingHeaders = trackingHeaders;
        this.compression = compression;
    }

    public EndpointSpec getEndpoint() {
        return this.endpoint;
    }

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public AuthConfig getAuth() {
        return this.auth;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public int getConnectionKeepAliveInMillis() {
        return this.connectionKeepAliveInMillis;
    }

    public ThreadPoolGroupConfig getThreadPoolGroupConfig() {
        return this.threadPoolGroupConfig;
    }

    public String getType() {
        return this.type;
    }

    public String getService() {
        return this.service;
    }

    public String getFallbackAddress() {
        return this.fallbackAddress;
    }

    public HystrixCommandConfig getRuntime() {
        return this.runtime;
    }

    public SentinelCommandConfig getSentinelCommandConfig() {
        return this.sentinelCommandConfig;
    }

    public Set<RevolverHttpApiConfig> getApis() {
        return this.apis;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public boolean isTrackingHeaders() {
        return this.trackingHeaders;
    }

    public boolean isCompression() {
        return this.compression;
    }

    public RevolverHttpServiceSplitConfig getServiceSplitConfig() {
        return this.serviceSplitConfig;
    }

    public RevolverExecutorType getRevolverExecutorType() {
        return this.revolverExecutorType;
    }

    public void setEndpoint(EndpointSpec endpoint) {
        this.endpoint = endpoint;
    }

    public void setAuthEnabled(boolean authEnabled) {
        this.authEnabled = authEnabled;
    }

    public void setAuth(AuthConfig auth) {
        this.auth = auth;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public void setConnectionKeepAliveInMillis(int connectionKeepAliveInMillis) {
        this.connectionKeepAliveInMillis = connectionKeepAliveInMillis;
    }

    public void setThreadPoolGroupConfig(ThreadPoolGroupConfig threadPoolGroupConfig) {
        this.threadPoolGroupConfig = threadPoolGroupConfig;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setFallbackAddress(String fallbackAddress) {
        this.fallbackAddress = fallbackAddress;
    }

    public void setRuntime(HystrixCommandConfig runtime) {
        this.runtime = runtime;
    }

    public void setSentinelCommandConfig(SentinelCommandConfig sentinelCommandConfig) {
        this.sentinelCommandConfig = sentinelCommandConfig;
    }

    public void setApis(Set<RevolverHttpApiConfig> apis) {
        this.apis = apis;
    }

    public void setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    public void setTrackingHeaders(boolean trackingHeaders) {
        this.trackingHeaders = trackingHeaders;
    }

    public void setCompression(boolean compression) {
        this.compression = compression;
    }

    public void setServiceSplitConfig(RevolverHttpServiceSplitConfig serviceSplitConfig) {
        this.serviceSplitConfig = serviceSplitConfig;
    }

    public void setRevolverExecutorType(RevolverExecutorType revolverExecutorType) {
        this.revolverExecutorType = revolverExecutorType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverServiceConfig)) {
            return false;
        }
        RevolverServiceConfig other = (RevolverServiceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EndpointSpec this$endpoint = this.getEndpoint();
        EndpointSpec other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        if (this.isAuthEnabled() != other.isAuthEnabled()) {
            return false;
        }
        AuthConfig this$auth = this.getAuth();
        AuthConfig other$auth = other.getAuth();
        if (this$auth == null ? other$auth != null : !this$auth.equals(other$auth)) {
            return false;
        }
        if (this.isSecured() != other.isSecured()) {
            return false;
        }
        String this$keyStorePath = this.getKeyStorePath();
        String other$keyStorePath = other.getKeyStorePath();
        if (this$keyStorePath == null ? other$keyStorePath != null : !this$keyStorePath.equals(other$keyStorePath)) {
            return false;
        }
        String this$keystorePassword = this.getKeystorePassword();
        String other$keystorePassword = other.getKeystorePassword();
        if (this$keystorePassword == null ? other$keystorePassword != null : !this$keystorePassword.equals(other$keystorePassword)) {
            return false;
        }
        if (this.getConnectionKeepAliveInMillis() != other.getConnectionKeepAliveInMillis()) {
            return false;
        }
        ThreadPoolGroupConfig this$threadPoolGroupConfig = this.getThreadPoolGroupConfig();
        ThreadPoolGroupConfig other$threadPoolGroupConfig = other.getThreadPoolGroupConfig();
        if (this$threadPoolGroupConfig == null ? other$threadPoolGroupConfig != null : !((Object)this$threadPoolGroupConfig).equals(other$threadPoolGroupConfig)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$service = this.getService();
        String other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        String this$fallbackAddress = this.getFallbackAddress();
        String other$fallbackAddress = other.getFallbackAddress();
        if (this$fallbackAddress == null ? other$fallbackAddress != null : !this$fallbackAddress.equals(other$fallbackAddress)) {
            return false;
        }
        HystrixCommandConfig this$runtime = this.getRuntime();
        HystrixCommandConfig other$runtime = other.getRuntime();
        if (this$runtime == null ? other$runtime != null : !((Object)this$runtime).equals(other$runtime)) {
            return false;
        }
        SentinelCommandConfig this$sentinelCommandConfig = this.getSentinelCommandConfig();
        SentinelCommandConfig other$sentinelCommandConfig = other.getSentinelCommandConfig();
        if (this$sentinelCommandConfig == null ? other$sentinelCommandConfig != null : !((Object)this$sentinelCommandConfig).equals(other$sentinelCommandConfig)) {
            return false;
        }
        Set<RevolverHttpApiConfig> this$apis = this.getApis();
        Set<RevolverHttpApiConfig> other$apis = other.getApis();
        if (this$apis == null ? other$apis != null : !((Object)this$apis).equals(other$apis)) {
            return false;
        }
        if (this.getConnectionPoolSize() != other.getConnectionPoolSize()) {
            return false;
        }
        if (this.isTrackingHeaders() != other.isTrackingHeaders()) {
            return false;
        }
        if (this.isCompression() != other.isCompression()) {
            return false;
        }
        RevolverHttpServiceSplitConfig this$serviceSplitConfig = this.getServiceSplitConfig();
        RevolverHttpServiceSplitConfig other$serviceSplitConfig = other.getServiceSplitConfig();
        if (this$serviceSplitConfig == null ? other$serviceSplitConfig != null : !((Object)this$serviceSplitConfig).equals(other$serviceSplitConfig)) {
            return false;
        }
        RevolverExecutorType this$revolverExecutorType = this.getRevolverExecutorType();
        RevolverExecutorType other$revolverExecutorType = other.getRevolverExecutorType();
        return !(this$revolverExecutorType == null ? other$revolverExecutorType != null : !((Object)((Object)this$revolverExecutorType)).equals((Object)other$revolverExecutorType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RevolverServiceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EndpointSpec $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        result = result * 59 + (this.isAuthEnabled() ? 79 : 97);
        AuthConfig $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : $auth.hashCode());
        result = result * 59 + (this.isSecured() ? 79 : 97);
        String $keyStorePath = this.getKeyStorePath();
        result = result * 59 + ($keyStorePath == null ? 43 : $keyStorePath.hashCode());
        String $keystorePassword = this.getKeystorePassword();
        result = result * 59 + ($keystorePassword == null ? 43 : $keystorePassword.hashCode());
        result = result * 59 + this.getConnectionKeepAliveInMillis();
        ThreadPoolGroupConfig $threadPoolGroupConfig = this.getThreadPoolGroupConfig();
        result = result * 59 + ($threadPoolGroupConfig == null ? 43 : ((Object)$threadPoolGroupConfig).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        String $fallbackAddress = this.getFallbackAddress();
        result = result * 59 + ($fallbackAddress == null ? 43 : $fallbackAddress.hashCode());
        HystrixCommandConfig $runtime = this.getRuntime();
        result = result * 59 + ($runtime == null ? 43 : ((Object)$runtime).hashCode());
        SentinelCommandConfig $sentinelCommandConfig = this.getSentinelCommandConfig();
        result = result * 59 + ($sentinelCommandConfig == null ? 43 : ((Object)$sentinelCommandConfig).hashCode());
        Set<RevolverHttpApiConfig> $apis = this.getApis();
        result = result * 59 + ($apis == null ? 43 : ((Object)$apis).hashCode());
        result = result * 59 + this.getConnectionPoolSize();
        result = result * 59 + (this.isTrackingHeaders() ? 79 : 97);
        result = result * 59 + (this.isCompression() ? 79 : 97);
        RevolverHttpServiceSplitConfig $serviceSplitConfig = this.getServiceSplitConfig();
        result = result * 59 + ($serviceSplitConfig == null ? 43 : ((Object)$serviceSplitConfig).hashCode());
        RevolverExecutorType $revolverExecutorType = this.getRevolverExecutorType();
        result = result * 59 + ($revolverExecutorType == null ? 43 : ((Object)((Object)$revolverExecutorType)).hashCode());
        return result;
    }

    public RevolverServiceConfig(EndpointSpec endpoint, boolean authEnabled, AuthConfig auth, boolean secured, String keyStorePath, String keystorePassword, int connectionKeepAliveInMillis, ThreadPoolGroupConfig threadPoolGroupConfig, String type, String service, String fallbackAddress, HystrixCommandConfig runtime, SentinelCommandConfig sentinelCommandConfig, Set<RevolverHttpApiConfig> apis, int connectionPoolSize, boolean trackingHeaders, boolean compression, RevolverHttpServiceSplitConfig serviceSplitConfig, RevolverExecutorType revolverExecutorType) {
        this.endpoint = endpoint;
        this.authEnabled = authEnabled;
        this.auth = auth;
        this.secured = secured;
        this.keyStorePath = keyStorePath;
        this.keystorePassword = keystorePassword;
        this.connectionKeepAliveInMillis = connectionKeepAliveInMillis;
        this.threadPoolGroupConfig = threadPoolGroupConfig;
        this.type = type;
        this.service = service;
        this.fallbackAddress = fallbackAddress;
        this.runtime = runtime;
        this.sentinelCommandConfig = sentinelCommandConfig;
        this.apis = apis;
        this.connectionPoolSize = connectionPoolSize;
        this.trackingHeaders = trackingHeaders;
        this.compression = compression;
        this.serviceSplitConfig = serviceSplitConfig;
        this.revolverExecutorType = revolverExecutorType;
    }

    public RevolverServiceConfig() {
    }

    public String toString() {
        return "RevolverServiceConfig(endpoint=" + this.getEndpoint() + ", authEnabled=" + this.isAuthEnabled() + ", auth=" + this.getAuth() + ", secured=" + this.isSecured() + ", keyStorePath=" + this.getKeyStorePath() + ", keystorePassword=" + this.getKeystorePassword() + ", connectionKeepAliveInMillis=" + this.getConnectionKeepAliveInMillis() + ", threadPoolGroupConfig=" + this.getThreadPoolGroupConfig() + ", type=" + this.getType() + ", service=" + this.getService() + ", fallbackAddress=" + this.getFallbackAddress() + ", runtime=" + this.getRuntime() + ", sentinelCommandConfig=" + this.getSentinelCommandConfig() + ", apis=" + this.getApis() + ", connectionPoolSize=" + this.getConnectionPoolSize() + ", trackingHeaders=" + this.isTrackingHeaders() + ", compression=" + this.isCompression() + ", serviceSplitConfig=" + this.getServiceSplitConfig() + ", revolverExecutorType=" + (Object)((Object)this.getRevolverExecutorType()) + ")";
    }
}

