/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import io.dropwizard.revolver.core.RevolverCommand;
import io.dropwizard.revolver.core.RevolverExecutionException;
import io.dropwizard.revolver.core.config.CommandHandlerConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.config.hystrix.ThreadPoolConfig;
import io.dropwizard.revolver.core.model.RevolverRequest;
import io.dropwizard.revolver.core.model.RevolverResponse;
import io.dropwizard.revolver.core.util.RevolverCommandHelper;
import io.dropwizard.revolver.core.util.RevolverExceptionHelper;
import io.dropwizard.revolver.http.ResilienceHttpContext;
import io.dropwizard.revolver.http.RevolverContext;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.util.ResilienceUtil;
import io.dropwizard.revolver.util.ThreadPoolUtil;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class ResilienceCommandExecutor<RequestType extends RevolverRequest, ResponseType extends RevolverResponse, ContextType extends RevolverContext, ServiceConfigurationType extends RevolverServiceConfig, CommandHandlerConfigurationType extends CommandHandlerConfig> {
    private static final Logger log = LoggerFactory.getLogger(ResilienceCommandExecutor.class);
    private static final long DEFAULT_TTL = 5000L;
    private final RevolverCommand<RequestType, ResponseType, ContextType, ServiceConfigurationType, CommandHandlerConfigurationType> revolverCommand;
    private final RequestType revolverRequest;

    public ResilienceCommandExecutor(RevolverCommand revolverCommand, RequestType revolverRequest) {
        this.revolverCommand = revolverCommand;
        this.revolverRequest = revolverRequest;
    }

    public RevolverResponse executeSync() throws Exception {
        try {
            return this.execute();
        }
        catch (Exception e) {
            if (e instanceof BulkheadFullException) {
                log.error("BulkheadFullException occurred");
                this.registerMetric();
            }
            throw e;
        }
    }

    public CompletableFuture<ResponseType> executeASync() {
        try {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    return this.execute();
                }
                catch (Exception e) {
                    throw this.getException(e);
                }
            });
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    public Observable executeAsyncAsObservable() {
        return Observable.fromCallable(() -> {
            try {
                return this.execute();
            }
            catch (Exception e) {
                throw this.getException(e);
            }
        });
    }

    private ResponseType execute() throws Exception {
        ResilienceHttpContext resilienceHttpContext = this.getResilienceContext();
        CircuitBreaker circuitBreaker = this.getCircuitBreaker(resilienceHttpContext);
        Bulkhead bulkhead = this.getBulkHead(resilienceHttpContext);
        TimeLimiter timeLimiter = this.getTimeoutConfig(resilienceHttpContext);
        Supplier<Future> supplier = () -> resilienceHttpContext.getExecutor().submit(() -> this.revolverCommand.execute(this.revolverCommand.getContext(), this.revolverRequest));
        Callable timeCallable = TimeLimiter.decorateFutureSupplier((TimeLimiter)timeLimiter, supplier);
        Callable circuitCallable = CircuitBreaker.decorateCallable((CircuitBreaker)circuitBreaker, (Callable)timeCallable);
        Callable bulkHeadCallable = Bulkhead.decorateCallable((Bulkhead)bulkhead, (Callable)circuitCallable);
        return (ResponseType)((RevolverResponse)bulkHeadCallable.call());
    }

    private ResilienceHttpContext getResilienceContext() {
        RevolverContext context = this.revolverCommand.getContext();
        ResilienceHttpContext resilienceHttpContext = context instanceof ResilienceHttpContext ? (ResilienceHttpContext)context : new ResilienceHttpContext();
        return resilienceHttpContext;
    }

    private String getThreadPoolName() {
        ThreadPoolConfig threadPoolConfig = this.revolverCommand.getApiConfiguration().getRuntime().getThreadPool();
        String threadPoolName = threadPoolConfig.getThreadPoolName();
        if (StringUtils.isEmpty((CharSequence)threadPoolName)) {
            return this.revolverRequest.getService() + "-" + this.revolverRequest.getApi();
        }
        return ThreadPoolUtil.getThreadPoolNameForService((String)this.revolverRequest.getService(), (String)threadPoolName);
    }

    private TimeLimiter getTimeoutConfig(ResilienceHttpContext resilienceHttpContext) {
        String apiName;
        RevolverServiceConfig serviceConfiguration = this.revolverCommand.getServiceConfiguration();
        CommandHandlerConfig apiConfiguration = this.revolverCommand.getApiConfiguration();
        Map<String, Integer> apiVsTimeout = resilienceHttpContext.getApiVsTimeout();
        long ttl = 0L;
        if (apiConfiguration instanceof RevolverHttpApiConfig && apiVsTimeout.get(apiName = ResilienceUtil.getApiName(serviceConfiguration, (RevolverHttpApiConfig)apiConfiguration)) != null) {
            ttl = apiVsTimeout.get(apiName).intValue();
        }
        if (ttl == 0L) {
            if (log.isDebugEnabled()) {
                log.debug("Timeout not set for api : {}", (Object)apiConfiguration.getApi());
            }
            ttl = 5000L;
        }
        TimeLimiterConfig config = TimeLimiterConfig.custom().timeoutDuration(Duration.ofMillis(ttl)).build();
        return TimeLimiter.of((TimeLimiterConfig)config);
    }

    private Bulkhead getBulkHead(ResilienceHttpContext resilienceHttpContext) {
        String threadPoolName;
        RevolverServiceConfig serviceConfiguration = this.revolverCommand.getServiceConfiguration();
        Map<String, Bulkhead> bulkheadMap = resilienceHttpContext.getPoolVsBulkHeadMap();
        Bulkhead bulkhead = bulkheadMap.get(threadPoolName = this.getThreadPoolName());
        if (bulkhead != null) {
            if (log.isDebugEnabled()) {
                log.debug("BulkheadName : {},  Available Calls : {}, Max Calls : {}, Wait Time : {}", new Object[]{bulkhead.getName(), bulkhead.getMetrics().getAvailableConcurrentCalls(), bulkhead.getMetrics().getMaxAllowedConcurrentCalls(), bulkhead.getBulkheadConfig().getMaxWaitDuration()});
            }
            return bulkhead;
        }
        if (log.isDebugEnabled()) {
            log.debug("No bulk head defined for threadPool : {} service : {}, api : {}", new Object[]{threadPoolName, this.revolverRequest.getService(), this.revolverRequest.getApi()});
        }
        if (StringUtils.isNotEmpty((CharSequence)(threadPoolName = serviceConfiguration.getService()))) {
            bulkhead = bulkheadMap.get(threadPoolName);
        }
        if (bulkhead == null) {
            log.debug("No bulk head defined for service : {}, api : {} threadPool : {}", new Object[]{this.revolverRequest.getService(), this.revolverRequest.getApi(), threadPoolName});
            bulkhead = Bulkhead.ofDefaults((String)"revolver");
        }
        return bulkhead;
    }

    private RevolverExecutionException getException(Throwable throwable) {
        return new RevolverExecutionException(RevolverExecutionException.Type.SERVICE_ERROR, String.format("Error executing resilience command %s", RevolverCommandHelper.getName(this.revolverRequest)), RevolverExceptionHelper.getLeafThrowable((Throwable)throwable));
    }

    private CircuitBreaker getCircuitBreaker(ResilienceHttpContext resilienceHttpContext) {
        Map<String, CircuitBreaker> circuitBreakerMap = resilienceHttpContext.getApiVsCircuitBreaker();
        RevolverServiceConfig serviceConfiguration = this.revolverCommand.getServiceConfiguration();
        CommandHandlerConfig apiConfiguration = this.revolverCommand.getApiConfiguration();
        String cbName = apiConfiguration instanceof RevolverHttpApiConfig ? ResilienceUtil.getCbName(serviceConfiguration, (RevolverHttpApiConfig)apiConfiguration) : serviceConfiguration.getService();
        CircuitBreaker circuitBreaker = circuitBreakerMap.get(cbName);
        if (circuitBreaker != null) {
            return circuitBreaker;
        }
        circuitBreaker = resilienceHttpContext.getDefaultCircuitBreaker();
        if (log.isDebugEnabled()) {
            log.debug("DefaultCircuitBreaker : {}", (Object)circuitBreaker);
        }
        return circuitBreaker;
    }

    private String getMetricName() {
        return "BulkheadFullException." + this.getThreadPoolName();
    }

    private void registerMetric() {
        try {
            if (this.getResilienceContext().getMetrics() == null) {
                return;
            }
            MetricRegistry metrics = this.getResilienceContext().getMetrics();
            Meter meter = metrics.meter(this.getMetricName());
            if (meter != null) {
                meter.mark();
            }
        }
        catch (Exception e) {
            log.error("Error occurred while registering metrics : ", (Throwable)e);
        }
    }
}

