/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core;

import com.alibaba.csp.sentinel.AsyncEntry;
import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.SphU;
import io.dropwizard.revolver.core.RevolverCommand;
import io.dropwizard.revolver.core.RevolverExecutionException;
import io.dropwizard.revolver.core.config.CommandHandlerConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.model.RevolverRequest;
import io.dropwizard.revolver.core.model.RevolverResponse;
import io.dropwizard.revolver.core.util.RevolverCommandHelper;
import io.dropwizard.revolver.core.util.RevolverExceptionHelper;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import rx.Observable;

public class SentinelCommandExecutor<RequestType extends RevolverRequest, ResponseType extends RevolverResponse> {
    private final RevolverRequest request;
    private final RevolverCommand revolverCommand;

    public SentinelCommandExecutor(RevolverCommand revolverCommand, RevolverRequest request) {
        this.revolverCommand = revolverCommand;
        this.request = request;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseType executeSync() {
        String resourceName = this.getResourceName();
        try (Entry entry = SphU.entry((String)resourceName);){
            RevolverResponse revolverResponse = this.revolverCommand.execute(this.revolverCommand.getContext(), this.request);
            return (ResponseType)revolverResponse;
        }
        catch (Throwable throwable3) {
            throw this.getException(throwable3);
        }
    }

    public CompletableFuture<ResponseType> executeASync() {
        try {
            AsyncEntry entry = SphU.asyncEntry((String)this.getResourceName());
            return CompletableFuture.supplyAsync(() -> {
                try {
                    RevolverResponse revolverResponse = this.revolverCommand.execute(this.revolverCommand.getContext(), this.request);
                    return revolverResponse;
                }
                catch (Throwable throwable) {
                    throw this.getException(throwable);
                }
                finally {
                    entry.exit();
                }
            });
        }
        catch (Throwable throwable) {
            throw this.getException(throwable);
        }
    }

    public Observable executeAsyncAsObservable() {
        return Observable.fromCallable(() -> {
            Entry entry = SphU.entry((String)this.getResourceName());
            try {
                RevolverResponse revolverResponse = this.revolverCommand.execute(this.revolverCommand.getContext(), this.request);
                return revolverResponse;
            }
            catch (Throwable throwable) {
                throw this.getException(throwable);
            }
            finally {
                entry.exit();
            }
        });
    }

    private String getResourceName() {
        RevolverServiceConfig serviceConfig = this.revolverCommand.getServiceConfiguration();
        CommandHandlerConfig apiConfig = this.revolverCommand.getApiConfiguration();
        if (apiConfig != null && apiConfig.getSentinelRunTime() != null && apiConfig.getSentinelRunTime().getFlowControlConfig() != null && StringUtils.isNotEmpty((CharSequence)apiConfig.getSentinelRunTime().getFlowControlConfig().getPoolName())) {
            return apiConfig.getSentinelRunTime().getFlowControlConfig().getPoolName();
        }
        if (serviceConfig != null && serviceConfig.getSentinelCommandConfig() != null && serviceConfig.getSentinelCommandConfig().getFlowControlConfig() != null && StringUtils.isNotEmpty((CharSequence)serviceConfig.getSentinelCommandConfig().getFlowControlConfig().getPoolName())) {
            return serviceConfig.getSentinelCommandConfig().getFlowControlConfig().getPoolName();
        }
        return this.request.getApi();
    }

    private RevolverExecutionException getException(Throwable throwable) {
        return new RevolverExecutionException(RevolverExecutionException.Type.SERVICE_ERROR, String.format("Error executing command %s", RevolverCommandHelper.getName((RevolverRequest)this.request)), RevolverExceptionHelper.getLeafThrowable((Throwable)throwable));
    }
}

