/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.confighandler;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.confighandler.ConfigLoadInfo;
import io.dropwizard.revolver.confighandler.ConfigUpdateEvent;
import io.dropwizard.revolver.confighandler.ConfigUpdateEventListener;
import io.dropwizard.revolver.core.RevolverContextFactory;
import io.dropwizard.revolver.core.config.RevolverConfig;
import io.dropwizard.revolver.core.config.RevolverConfigHolder;
import io.dropwizard.revolver.core.model.RevolverExecutorType;
import io.dropwizard.revolver.util.CommonUtils;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevolverConfigUpdateEventListener
implements ConfigUpdateEventListener {
    private static final Logger log = LoggerFactory.getLogger(RevolverConfigUpdateEventListener.class);
    private ObjectMapper objectMapper;
    private RevolverConfigHolder revolverConfigHolder;
    private String configAttribute;
    private ConfigLoadInfo configLoadInfo;

    public RevolverConfigUpdateEventListener(String configAttribute, ObjectMapper objectMapper, RevolverConfigHolder configHolder) {
        this.configAttribute = configAttribute;
        this.configLoadInfo = ConfigLoadInfo.builder().previousConfigHash("unknown").previousLoadTime(new Date()).build();
        this.objectMapper = objectMapper.copy();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.revolverConfigHolder = configHolder;
    }

    @Override
    public void initConfigLoadInfo(Map<String, ConfigLoadInfo> initialConfigLoadInfos) {
        this.configLoadInfo = initialConfigLoadInfos.getOrDefault(this.configAttribute, ConfigLoadInfo.builder().previousConfigHash("unknown").previousLoadTime(new Date()).build()).copy();
    }

    @Override
    public void configUpdated(ConfigUpdateEvent configUpdateEvent) {
        try {
            String configString = configUpdateEvent.getUpdatedConfig().get(this.configAttribute).toString();
            String currentConfigHash = CommonUtils.computeHash((String)configString);
            log.info("Old Config Hash for {} : {} | New Config Hash: {}", new Object[]{this.configAttribute, this.configLoadInfo.getPreviousConfigHash(), currentConfigHash});
            if (!this.configLoadInfo.getPreviousConfigHash().equals(currentConfigHash)) {
                this.reloadConfig(configString);
                this.configLoadInfo.setPreviousConfigHash(currentConfigHash);
                this.configLoadInfo.setPreviousLoadTime(new Date());
            }
        }
        catch (Exception e) {
            log.error("Error updating " + this.configAttribute + " configuration", (Throwable)e);
        }
    }

    private void reloadConfig(String configString) {
        try {
            RevolverConfig revolverConfig = (RevolverConfig)this.objectMapper.readValue(configString, RevolverConfig.class);
            this.revolverConfigHolder.setConfig(revolverConfig);
            this.configUpdated(revolverConfig);
        }
        catch (IOException e) {
            log.error("Error reloading revolver config: ", (Throwable)e);
        }
    }

    public synchronized void configUpdated(RevolverConfig revolverConfig) {
        RevolverBundle.loadServiceConfiguration(revolverConfig);
        RevolverContextFactory revolverContextFactory = RevolverBundle.revolverContextFactory;
        for (RevolverExecutorType revolverExecutorType : RevolverExecutorType.values()) {
            Optional.ofNullable(revolverContextFactory.getContext(revolverExecutorType)).ifPresent(revolverHttpContext -> revolverHttpContext.reload(revolverConfig));
        }
    }
}

