/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Maps;
import io.dropwizard.revolver.core.model.RevolverExecutorType;
import io.dropwizard.revolver.optimizer.OptimizerCacheKey;
import io.dropwizard.revolver.optimizer.OptimizerMetrics;
import io.dropwizard.revolver.optimizer.OptimizerMetricsCache;
import io.dropwizard.revolver.optimizer.config.OptimizerConfig;
import io.dropwizard.revolver.optimizer.hystrix.LatencyMetric;
import io.dropwizard.revolver.optimizer.hystrix.ThreadPoolMetric;
import io.dropwizard.revolver.optimizer.models.OptimizerMetricType;
import io.dropwizard.revolver.optimizer.resilience.BulkheadMetric;
import java.util.Set;
import java.util.SortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizerMetricsCollector
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(OptimizerMetricsCollector.class);
    public static final String ALLOWED_CONCURRENT_CALLS_METRIC_NAME = "resilience4jBulkheadMaxAllowedConcurrentCalls";
    public static final String MAX_ROLLING_ACTIVE_THREADS_METRIC_NAME = "maxRollingActiveThreads";
    private MetricRegistry metrics;
    private OptimizerMetricsCache optimizerMetricsCache;
    private OptimizerConfig optimizerConfig;

    @Override
    public void run() {
        log.debug("Running optimiser metrics collection job");
        SortedMap gauges = this.metrics.getGauges();
        Long time = System.currentTimeMillis();
        try {
            this.captureThreadPoolMetrics(gauges, time);
            this.captureBulkheadConcurrencyMetrics(gauges, time);
            this.captureLatencyMetrics(gauges, time);
        }
        catch (Exception e) {
            log.error("Error occurred while executing metrics collector : ", (Throwable)e);
        }
    }

    private void captureBulkheadConcurrencyMetrics(SortedMap<String, Gauge> gauges, Long time) {
        gauges.forEach((key, gauge) -> this.updateOptimizerMetricsCache(RevolverExecutorType.RESILIENCE, (String)key, (Gauge)gauge, time, 2, OptimizerMetricType.BULKHEAD, BulkheadMetric.metrics(), gauges));
    }

    private void captureThreadPoolMetrics(SortedMap<String, Gauge> gauges, Long time) {
        gauges.forEach((key, gauge) -> this.updateOptimizerMetricsCache(RevolverExecutorType.HYSTRIX, (String)key, (Gauge)gauge, time, 1, OptimizerMetricType.THREAD_POOL, ThreadPoolMetric.metrics(), gauges));
    }

    private void captureLatencyMetrics(SortedMap<String, Gauge> gauges, Long time) {
        gauges.forEach((key, gauge) -> this.updateOptimizerMetricsCache(RevolverExecutorType.HYSTRIX, (String)key, (Gauge)gauge, time, 1, OptimizerMetricType.LATENCY, LatencyMetric.metrics(), gauges));
    }

    private void updateOptimizerMetricsCache(RevolverExecutorType executorType, String key, Gauge gauge, long time, int keyStartIndex, OptimizerMetricType metricType, Set<String> metricsToCapture, SortedMap<String, Gauge> gauges) {
        String[] splits = key.split("\\.");
        int length = splits.length;
        if (length < metricType.getMinValidLength()) {
            return;
        }
        String metricName = this.resolveMetricName(executorType, splits);
        if (!metricsToCapture.contains(metricName) || !(gauge.getValue() instanceof Number)) {
            return;
        }
        OptimizerCacheKey cacheKey = this.getOptimizerCacheKey(executorType, time, splits, keyStartIndex, length, metricType);
        if (this.optimizerMetricsCache.get(cacheKey) == null) {
            this.optimizerMetricsCache.put(cacheKey, OptimizerMetrics.builder().metrics(Maps.newHashMap()).build());
        }
        OptimizerMetrics optimizerMetrics = this.optimizerMetricsCache.get(cacheKey);
        switch (executorType) {
            case RESILIENCE: {
                this.updateMetricsCacheForResilience(optimizerMetrics, splits, gauges, gauge, key);
                break;
            }
            default: {
                optimizerMetrics.getMetrics().put(metricName, (Number)gauge.getValue());
            }
        }
    }

    private void updateMetricsCacheForResilience(OptimizerMetrics optimizerMetrics, String[] splits, SortedMap<String, Gauge> gauges, Gauge gauge, String key) {
        String allowedCallsMetricName = this.getMetricName(splits, ALLOWED_CONCURRENT_CALLS_METRIC_NAME);
        Gauge allowedCallGauge = (Gauge)gauges.get(allowedCallsMetricName);
        if (allowedCallGauge == null || !(allowedCallGauge.getValue() instanceof Number)) {
            return;
        }
        String availableCallsMetricName = this.getMetricName(splits, "availableCalls");
        Double maxRollingActiveThreads = (Double)allowedCallGauge.getValue() - (Double)gauge.getValue();
        if (log.isDebugEnabled()) {
            log.debug("Key : {} Value : {}, Available : {}, AvailableCallsMetricName : {}", new Object[]{key, maxRollingActiveThreads, gauge.getValue(), availableCallsMetricName});
        }
        optimizerMetrics.getMetrics().put(MAX_ROLLING_ACTIVE_THREADS_METRIC_NAME, maxRollingActiveThreads);
    }

    private String getMetricName(String[] splits, String prefix) {
        StringBuilder allowedCallsMetricNameBuilder = new StringBuilder();
        allowedCallsMetricNameBuilder.append(prefix);
        for (int i = 1; i < splits.length; ++i) {
            allowedCallsMetricNameBuilder.append(".");
            allowedCallsMetricNameBuilder.append(splits[i]);
        }
        return allowedCallsMetricNameBuilder.toString();
    }

    private OptimizerCacheKey getOptimizerCacheKey(RevolverExecutorType executorType, Long time, String[] splits, int keyStartIndex, int length, OptimizerMetricType metricType) {
        StringBuilder sb = new StringBuilder();
        String delimiter = "";
        int keyEndIndex = this.findKeyEndIndex(executorType, length);
        for (int i = keyStartIndex; i <= keyEndIndex; ++i) {
            sb.append(delimiter);
            sb.append(splits[i]);
            delimiter = ".";
        }
        return new OptimizerCacheKey(time, sb.toString(), metricType);
    }

    private String resolveMetricName(RevolverExecutorType executorType, String[] splits) {
        switch (executorType) {
            case HYSTRIX: {
                return splits[splits.length - 1];
            }
            case RESILIENCE: {
                return splits[0];
            }
        }
        log.error("Executor type not supported while resolving metric name in optimizer collector");
        throw new IllegalArgumentException("Executor type not supported while resolving metric name in optimizer collector");
    }

    private int findKeyEndIndex(RevolverExecutorType executorType, int length) {
        switch (executorType) {
            case RESILIENCE: {
                return length - 1;
            }
            case HYSTRIX: {
                return length - 2;
            }
        }
        log.error("executor type not supported while resolving key end index in optimizer collector");
        throw new IllegalArgumentException("executor type not supported while resolving key end index in optimizer collector");
    }

    public static OptimizerMetricsCollectorBuilder builder() {
        return new OptimizerMetricsCollectorBuilder();
    }

    public OptimizerMetricsCollector(MetricRegistry metrics, OptimizerMetricsCache optimizerMetricsCache, OptimizerConfig optimizerConfig) {
        this.metrics = metrics;
        this.optimizerMetricsCache = optimizerMetricsCache;
        this.optimizerConfig = optimizerConfig;
    }

    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    public OptimizerMetricsCache getOptimizerMetricsCache() {
        return this.optimizerMetricsCache;
    }

    public OptimizerConfig getOptimizerConfig() {
        return this.optimizerConfig;
    }

    public void setMetrics(MetricRegistry metrics) {
        this.metrics = metrics;
    }

    public void setOptimizerMetricsCache(OptimizerMetricsCache optimizerMetricsCache) {
        this.optimizerMetricsCache = optimizerMetricsCache;
    }

    public void setOptimizerConfig(OptimizerConfig optimizerConfig) {
        this.optimizerConfig = optimizerConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptimizerMetricsCollector)) {
            return false;
        }
        OptimizerMetricsCollector other = (OptimizerMetricsCollector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MetricRegistry this$metrics = this.getMetrics();
        MetricRegistry other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !this$metrics.equals(other$metrics)) {
            return false;
        }
        OptimizerMetricsCache this$optimizerMetricsCache = this.getOptimizerMetricsCache();
        OptimizerMetricsCache other$optimizerMetricsCache = other.getOptimizerMetricsCache();
        if (this$optimizerMetricsCache == null ? other$optimizerMetricsCache != null : !((Object)this$optimizerMetricsCache).equals(other$optimizerMetricsCache)) {
            return false;
        }
        OptimizerConfig this$optimizerConfig = this.getOptimizerConfig();
        OptimizerConfig other$optimizerConfig = other.getOptimizerConfig();
        return !(this$optimizerConfig == null ? other$optimizerConfig != null : !this$optimizerConfig.equals(other$optimizerConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptimizerMetricsCollector;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MetricRegistry $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : $metrics.hashCode());
        OptimizerMetricsCache $optimizerMetricsCache = this.getOptimizerMetricsCache();
        result = result * 59 + ($optimizerMetricsCache == null ? 43 : ((Object)$optimizerMetricsCache).hashCode());
        OptimizerConfig $optimizerConfig = this.getOptimizerConfig();
        result = result * 59 + ($optimizerConfig == null ? 43 : $optimizerConfig.hashCode());
        return result;
    }

    public String toString() {
        return "OptimizerMetricsCollector(metrics=" + this.getMetrics() + ", optimizerMetricsCache=" + this.getOptimizerMetricsCache() + ", optimizerConfig=" + this.getOptimizerConfig() + ")";
    }

    public static class OptimizerMetricsCollectorBuilder {
        private MetricRegistry metrics;
        private OptimizerMetricsCache optimizerMetricsCache;
        private OptimizerConfig optimizerConfig;

        OptimizerMetricsCollectorBuilder() {
        }

        public OptimizerMetricsCollectorBuilder metrics(MetricRegistry metrics) {
            this.metrics = metrics;
            return this;
        }

        public OptimizerMetricsCollectorBuilder optimizerMetricsCache(OptimizerMetricsCache optimizerMetricsCache) {
            this.optimizerMetricsCache = optimizerMetricsCache;
            return this;
        }

        public OptimizerMetricsCollectorBuilder optimizerConfig(OptimizerConfig optimizerConfig) {
            this.optimizerConfig = optimizerConfig;
            return this;
        }

        public OptimizerMetricsCollector build() {
            return new OptimizerMetricsCollector(this.metrics, this.optimizerMetricsCache, this.optimizerConfig);
        }

        public String toString() {
            return "OptimizerMetricsCollector.OptimizerMetricsCollectorBuilder(metrics=" + this.metrics + ", optimizerMetricsCache=" + this.optimizerMetricsCache + ", optimizerConfig=" + this.optimizerConfig + ")";
        }
    }
}

