/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer.hystrix;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum LatencyMetric {
    LATENCY_PERCENTILE_995("latencyExecute_percentile_995"),
    LATENCY_PERCENTILE_99("latencyExecute_percentile_99"),
    LATENCY_PERCENTILE_75("latencyExecute_percentile_75"),
    LATENCY_PERCENTILE_50("latencyExecute_percentile_50");

    private static final Map<String, LatencyMetric> lookup;
    String metricName;

    private LatencyMetric(String metricName) {
        this.metricName = metricName;
    }

    public static LatencyMetric get(String metricName) {
        return lookup.get(metricName);
    }

    public static Set<String> metrics() {
        return lookup.keySet();
    }

    public String getMetricName() {
        return this.metricName;
    }

    static {
        lookup = new HashMap<String, LatencyMetric>();
        for (LatencyMetric s : EnumSet.allOf(LatencyMetric.class)) {
            lookup.put(s.getMetricName(), s);
        }
    }
}

