/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.resource;

import com.codahale.metrics.annotation.Metered;
import com.google.common.collect.ImmutableMap;
import io.dropwizard.revolver.confighandler.DynamicConfigHandler;
import io.swagger.annotations.ApiOperation;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/revolver")
@Singleton
public class RevolverConfigResource {
    private static final Logger log = LoggerFactory.getLogger(RevolverConfigResource.class);
    private DynamicConfigHandler dynamicConfigHandler;

    public RevolverConfigResource(DynamicConfigHandler dynamicConfigHandler) {
        this.dynamicConfigHandler = dynamicConfigHandler;
    }

    @Path(value="/v1/config/reload")
    @POST
    @Metered
    @ApiOperation(value="Reload configuration")
    @Produces(value={"application/json"})
    public Response reload() {
        long start = System.currentTimeMillis();
        String hash = this.dynamicConfigHandler.refreshConfig();
        long end = System.currentTimeMillis() - start;
        if (hash == null) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok((Object)ImmutableMap.builder().put((Object)"hash", (Object)hash).put((Object)"timeTaken", (Object)end).build()).build();
    }

    @Path(value="/v1/config/info")
    @GET
    @Metered
    @ApiOperation(value="Configuration reload info")
    @Produces(value={"application/json"})
    public Response info() {
        return Response.ok((Object)this.dynamicConfigHandler.getConfigLoadInfo()).build();
    }

    public static RevolverConfigResourceBuilder builder() {
        return new RevolverConfigResourceBuilder();
    }

    public DynamicConfigHandler getDynamicConfigHandler() {
        return this.dynamicConfigHandler;
    }

    public void setDynamicConfigHandler(DynamicConfigHandler dynamicConfigHandler) {
        this.dynamicConfigHandler = dynamicConfigHandler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverConfigResource)) {
            return false;
        }
        RevolverConfigResource other = (RevolverConfigResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DynamicConfigHandler this$dynamicConfigHandler = this.getDynamicConfigHandler();
        DynamicConfigHandler other$dynamicConfigHandler = other.getDynamicConfigHandler();
        return !(this$dynamicConfigHandler == null ? other$dynamicConfigHandler != null : !this$dynamicConfigHandler.equals(other$dynamicConfigHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RevolverConfigResource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DynamicConfigHandler $dynamicConfigHandler = this.getDynamicConfigHandler();
        result = result * 59 + ($dynamicConfigHandler == null ? 43 : $dynamicConfigHandler.hashCode());
        return result;
    }

    public String toString() {
        return "RevolverConfigResource(dynamicConfigHandler=" + this.getDynamicConfigHandler() + ")";
    }

    public static class RevolverConfigResourceBuilder {
        private DynamicConfigHandler dynamicConfigHandler;

        RevolverConfigResourceBuilder() {
        }

        public RevolverConfigResourceBuilder dynamicConfigHandler(DynamicConfigHandler dynamicConfigHandler) {
            this.dynamicConfigHandler = dynamicConfigHandler;
            return this;
        }

        public RevolverConfigResource build() {
            return new RevolverConfigResource(this.dynamicConfigHandler);
        }

        public String toString() {
            return "RevolverConfigResource.RevolverConfigResourceBuilder(dynamicConfigHandler=" + this.dynamicConfigHandler + ")";
        }
    }
}

