/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core;

import com.codahale.metrics.MetricRegistry;
import com.collections.CollectionUtils;
import com.google.common.collect.Maps;
import io.dropwizard.revolver.core.config.RevolverConfig;
import io.dropwizard.revolver.core.model.RevolverExecutorType;
import io.dropwizard.revolver.http.RevolverHttpContext;
import io.dropwizard.setup.Environment;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevolverContextFactory {
    private static final Logger log = LoggerFactory.getLogger(RevolverContextFactory.class);
    private final Map<RevolverExecutorType, RevolverHttpContext> CONTEXT_MAP = Maps.newHashMap();

    public RevolverContextFactory(Environment environment, RevolverConfig revolverConfig, MetricRegistry metrics) {
        Reflections reflections = new Reflections("io.dropwizard.revolver.http", new Scanner[0]);
        Set subTypes = reflections.getSubTypesOf(RevolverHttpContext.class);
        for (Class subType : CollectionUtils.nullSafeSet((Set)subTypes)) {
            try {
                Object obj = subType.newInstance();
                if (!(obj instanceof RevolverHttpContext)) continue;
                RevolverHttpContext revolverHttpContext = (RevolverHttpContext)obj;
                this.CONTEXT_MAP.putIfAbsent(revolverHttpContext.getExecutorType(), revolverHttpContext);
                revolverHttpContext.initialize(environment, revolverConfig, metrics);
            }
            catch (InstantiationException e) {
                log.error("Error occurred while initializing the subtype : {} with exception {}", (Object)subType, (Object)e);
            }
            catch (IllegalAccessException e) {
                log.error("Error occurred while initializing the subtype : {} with exception {}", (Object)subType, (Object)e);
            }
        }
    }

    public RevolverHttpContext getContext(RevolverExecutorType revolverExecutorType) {
        return this.CONTEXT_MAP.get(revolverExecutorType);
    }
}

