/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.vertx.routes;

import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.resource.RevolverRequestResource;
import io.dropwizard.revolver.vertx.RequestUtil;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevolverRequestRegistry {
    private static final Logger log = LoggerFactory.getLogger(RevolverRequestRegistry.class);
    private final Router router;
    private final RevolverRequestResource revolverRequestResource;

    public RevolverRequestRegistry(Router router, RevolverRequestResource revolverRequestResource) {
        this.router = router;
        this.revolverRequestResource = revolverRequestResource;
    }

    public void register() {
        this.router.route().path("/apis/*").method(HttpMethod.GET).handler(this::getResource);
        this.router.route().path("/apis/*").method(HttpMethod.POST).handler(this::postResource);
    }

    private void getResource(RoutingContext routingContext) {
        log.info("Executing via vertx for path : {}", (Object)routingContext.normalisedPath());
        UriInfo uriInfo = RequestUtil.getUriInfo(routingContext);
        HttpHeaders headers = RequestUtil.getHeaders(routingContext);
        String service = RequestUtil.getServiceName(routingContext);
        String path = RequestUtil.getApiPath(routingContext);
        byte[] body = RequestUtil.getBody(routingContext);
        log.info("Service : {}, Path : {}", (Object)service, (Object)path);
        try {
            this.revolverRequestResource.processRequest(routingContext, service, RevolverHttpApiConfig.RequestMethod.GET, path, headers, uriInfo, body);
        }
        catch (Exception e) {
            log.error("Error occurred while executing resource ", (Throwable)e);
        }
        log.info("Execution completed : " + routingContext.getBody());
    }

    private void postResource(RoutingContext routingContext) {
        log.info("Executing via vertx for path : {}", (Object)routingContext.normalisedPath());
        UriInfo uriInfo = RequestUtil.getUriInfo(routingContext);
        HttpHeaders headers = RequestUtil.getHeaders(routingContext);
        String service = RequestUtil.getServiceName(routingContext);
        String path = RequestUtil.getApiPath(routingContext);
        byte[] body = RequestUtil.getBody(routingContext);
        String buffer = routingContext.getBody() == null ? "" : routingContext.getBody().toString();
        log.info("Service : {}, Path : {}, Body : {}", new Object[]{service, path, buffer});
        try {
            this.revolverRequestResource.processRequest(routingContext, service, RevolverHttpApiConfig.RequestMethod.POST, path, headers, uriInfo, body);
        }
        catch (Exception e) {
            log.error("Error occurred while executing resource ", (Throwable)e);
        }
        log.info("Execution completed : " + routingContext.getBody());
    }

    public static RevolverRequestRegistryBuilder builder() {
        return new RevolverRequestRegistryBuilder();
    }

    public static class RevolverRequestRegistryBuilder {
        private Router router;
        private RevolverRequestResource revolverRequestResource;

        RevolverRequestRegistryBuilder() {
        }

        public RevolverRequestRegistryBuilder router(Router router) {
            this.router = router;
            return this;
        }

        public RevolverRequestRegistryBuilder revolverRequestResource(RevolverRequestResource revolverRequestResource) {
            this.revolverRequestResource = revolverRequestResource;
            return this;
        }

        public RevolverRequestRegistry build() {
            return new RevolverRequestRegistry(this.router, this.revolverRequestResource);
        }

        public String toString() {
            return "RevolverRequestRegistry.RevolverRequestRegistryBuilder(router=" + this.router + ", revolverRequestResource=" + this.revolverRequestResource + ")";
        }
    }
}

