/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.vertx.routes;

import io.dropwizard.revolver.resource.RevolverRequestResource;
import io.dropwizard.revolver.vertx.routes.RevolverRequestRegistry;
import io.vertx.ext.web.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterRegistry {
    private static final Logger log = LoggerFactory.getLogger(RouterRegistry.class);

    public RouterRegistry(Router router, RevolverRequestResource revolverRequestResource) {
        RevolverRequestRegistry.builder().router(router).revolverRequestResource(revolverRequestResource).build().register();
    }

    public static RouterRegistryBuilder builder() {
        return new RouterRegistryBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RouterRegistry)) {
            return false;
        }
        RouterRegistry other = (RouterRegistry)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RouterRegistry;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "RouterRegistry()";
    }

    public static class RouterRegistryBuilder {
        private Router router;
        private RevolverRequestResource revolverRequestResource;

        RouterRegistryBuilder() {
        }

        public RouterRegistryBuilder router(Router router) {
            this.router = router;
            return this;
        }

        public RouterRegistryBuilder revolverRequestResource(RevolverRequestResource revolverRequestResource) {
            this.revolverRequestResource = revolverRequestResource;
            return this;
        }

        public RouterRegistry build() {
            return new RouterRegistry(this.router, this.revolverRequestResource);
        }

        public String toString() {
            return "RouterRegistry.RouterRegistryBuilder(router=" + this.router + ", revolverRequestResource=" + this.revolverRequestResource + ")";
        }
    }
}

