package io.dropwizard.revolver.routes;

import io.dropwizard.revolver.http.config.RevolverHttpApiConfig.RequestMethod;
import io.dropwizard.revolver.resource.RevolverRequestResource;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.TimeoutHandler;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import java.util.regex.MatchResult;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import lombok.Builder;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.glassfish.jersey.server.internal.process.Endpoint;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.RuntimeResource;
import org.glassfish.jersey.uri.UriTemplate;

@Slf4j
@Data
public class RouterRegistry {

    private final Router router;

    private final RevolverRequestResource revolverRequestResource;


    @Builder
    public RouterRegistry(Router router, RevolverRequestResource revolverRequestResource) {
        this.router = router;
        this.revolverRequestResource = revolverRequestResource;
    }

    public void register() {

        //Test APIs
        router.route("/apis/*")
                .method(HttpMethod.GET)
                .handler(this::testResource)
                .handler(TimeoutHandler.create(1000, 504));
        router.route()
                .path("/apis/*")
                .method(HttpMethod.GET)
                .handler(this::testResource)
                .handler(TimeoutHandler.create(1000, 504));
        router.route()
                .pathRegex(".*")
                .method(HttpMethod.GET)
                .handler(this::testResource)
                .handler(TimeoutHandler.create(1000, 504));
    }


    private void testResource(RoutingContext routingContext) {
        UriInfo uriInfo = getUriInfo(routingContext);
        try {
            revolverRequestResource.processRequest("test", RequestMethod.GET, routingContext.normalisedPath(), null,
                    uriInfo, routingContext.getBody()
                            .getBytes());
        } catch (Exception e) {
            //Do nothing
        }
        System.out.println("Execution completed :" + routingContext.getBody());
    }

    private UriInfo getUriInfo(RoutingContext routingContext) {

        UriInfo uriInfo = new org.glassfish.jersey.server.internal.routing.RoutingContext() {
            @Override
            public void pushMatchResult(MatchResult matchResult) {

            }

            @Override
            public void pushMatchedResource(Object resource) {

            }

            @Override
            public Object peekMatchedResource() {
                return null;
            }

            @Override
            public void pushTemplates(UriTemplate resourceTemplate, UriTemplate methodTemplate) {

            }

            @Override
            public String getFinalMatchingGroup() {
                return null;
            }

            @Override
            public void pushLeftHandPath() {

            }

            @Override
            public void setEndpoint(Endpoint endpoint) {
                this.setEndpoint(endpoint);
            }

            @Override
            public Endpoint getEndpoint() {
                return this.getEndpoint();
            }

            @Override
            public void setMatchedResourceMethod(ResourceMethod resourceMethod) {

            }

            @Override
            public void pushMatchedLocator(ResourceMethod resourceLocator) {

            }

            @Override
            public void pushMatchedRuntimeResource(RuntimeResource runtimeResource) {

            }

            @Override
            public void pushLocatorSubResource(Resource subResourceFromLocator) {

            }

            @Override
            public void setMappedThrowable(Throwable throwable) {

            }

            @Override
            public Method getResourceMethod() {
                return null;
            }

            @Override
            public Class<?> getResourceClass() {
                return null;
            }

            @Override
            public Throwable getMappedThrowable() {
                return null;
            }

            @Override
            public List<MatchResult> getMatchedResults() {
                return null;
            }

            @Override
            public List<UriTemplate> getMatchedTemplates() {
                return null;
            }

            @Override
            public List<PathSegment> getPathSegments(String name) {
                return null;
            }

            @Override
            public List<PathSegment> getPathSegments(String name, boolean decode) {
                return null;
            }

            @Override
            public List<RuntimeResource> getMatchedRuntimeResources() {
                return null;
            }

            @Override
            public ResourceMethod getMatchedResourceMethod() {
                return null;
            }

            @Override
            public Resource getMatchedModelResource() {
                return null;
            }

            @Override
            public List<ResourceMethod> getMatchedResourceLocators() {
                return null;
            }

            @Override
            public List<Resource> getLocatorSubResources() {
                return null;
            }

            @Override
            public String getPath() {
                return routingContext.normalisedPath();
            }

            @Override
            public String getPath(boolean decode) {
                return null;
            }

            @Override
            public List<PathSegment> getPathSegments() {
                return null;
            }

            @Override
            public List<PathSegment> getPathSegments(boolean decode) {
                return null;
            }

            @Override
            public URI getRequestUri() {
                return null;
            }

            @Override
            public UriBuilder getRequestUriBuilder() {
                return null;
            }

            @Override
            public URI getAbsolutePath() {
                return null;
            }

            @Override
            public UriBuilder getAbsolutePathBuilder() {
                return null;
            }

            @Override
            public URI getBaseUri() {
                return null;
            }

            @Override
            public UriBuilder getBaseUriBuilder() {
                return null;
            }

            @Override
            public MultivaluedMap<String, String> getPathParameters() {
                return null;
            }

            @Override
            public MultivaluedMap<String, String> getPathParameters(boolean decode) {
                return null;
            }

            @Override
            public MultivaluedMap<String, String> getQueryParameters() {
                return null;
            }

            @Override
            public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
                return null;
            }

            @Override
            public List<String> getMatchedURIs() {
                return null;
            }

            @Override
            public List<String> getMatchedURIs(boolean decode) {
                return null;
            }

            @Override
            public List<Object> getMatchedResources() {
                return null;
            }

            @Override
            public URI resolve(URI uri) {
                return null;
            }

            @Override
            public URI relativize(URI uri) {
                return null;
            }
        };
        return uriInfo;
    }

    private void testVertexResource(RoutingContext routingContext) {

        try {
            Thread.sleep(3000);
            System.out.println("Hi");
        } catch (InterruptedException e) {
            log.error("Thread interrupted", e);
        }
        System.out.println("Execution completed for vertx");
        routingContext.response()
                .setStatusCode(202)
                .end("Hello");
    }

}
