/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.vertx;

import io.dropwizard.revolver.resource.RevolverRequestResource;
import io.dropwizard.revolver.vertx.RouterRegistry;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.ext.web.Router;
import java.util.Objects;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevolverVerticle
extends AbstractVerticle {
    private static final Logger log = LoggerFactory.getLogger(RevolverVerticle.class);
    private RevolverRequestResource revolverRequestResource;

    public RevolverVerticle(RevolverRequestResource revolverRequestResource) {
        this.revolverRequestResource = revolverRequestResource;
    }

    public void start(Promise<Void> startPromise) throws Exception {
        Router router = Router.router((Vertx)this.vertx);
        RouterRegistry.builder().router(router).revolverRequestResource(this.revolverRequestResource).build().register();
        log.info("Starting server..");
        this.vertx.createHttpServer().requestHandler((Handler)router).listen(8080, Objects.nonNull(System.getenv("HOST")) ? System.getenv("HOST") : "localhost", event -> Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.vertx.createHttpServer().requestHandler((Handler)router).close(r -> log.info("Closing httpServer"));
            log.info("Shutting down..");
            LogManager.shutdown();
        })));
    }

    public static RevolverVerticleBuilder builder() {
        return new RevolverVerticleBuilder();
    }

    public static class RevolverVerticleBuilder {
        private RevolverRequestResource revolverRequestResource;

        RevolverVerticleBuilder() {
        }

        public RevolverVerticleBuilder revolverRequestResource(RevolverRequestResource revolverRequestResource) {
            this.revolverRequestResource = revolverRequestResource;
            return this;
        }

        public RevolverVerticle build() {
            return new RevolverVerticle(this.revolverRequestResource);
        }

        public String toString() {
            return "RevolverVerticle.RevolverVerticleBuilder(revolverRequestResource=" + this.revolverRequestResource + ")";
        }
    }
}

