/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.riemann;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.codahale.metrics.riemann.Riemann;
import com.codahale.metrics.riemann.ValueFilterMap;
import io.riemann.riemann.client.EventDSL;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiemannReporter
extends ScheduledReporter {
    private static final Logger log = LoggerFactory.getLogger(RiemannReporter.class);
    private final Riemann riemann;
    private final Clock clock;
    private final String prefix;
    private final String separator;
    private final String localHost;
    private final List<String> tags;
    private final Float ttl;
    private final ValueFilterMap valueFilterMap;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private RiemannReporter(MetricRegistry registry, Riemann riemann, Clock clock, TimeUnit rateUnit, TimeUnit durationUnit, Float ttl, String prefix, String separator, String localHost, List<String> tags, MetricFilter filter, ValueFilterMap valueFilterMap) {
        super(registry, "riemann-reporter", filter, rateUnit, durationUnit);
        this.riemann = riemann;
        this.clock = clock;
        this.prefix = prefix;
        this.separator = separator;
        this.localHost = localHost;
        this.tags = tags;
        this.ttl = ttl;
        this.valueFilterMap = valueFilterMap;
    }

    private EventClosure newEvent(final String metricName, final long timestamp, final String metricType) {
        final String prefix = this.prefix;
        final String separator = this.separator;
        return new EventClosure(){

            @Override
            public EventDSL name(String ... components) {
                EventDSL event = ((RiemannReporter)RiemannReporter.this).riemann.client.event();
                if (RiemannReporter.this.localHost != null) {
                    event.host(RiemannReporter.this.localHost);
                }
                if (RiemannReporter.this.ttl != null) {
                    event.ttl(RiemannReporter.this.ttl.floatValue());
                }
                if (!RiemannReporter.this.tags.isEmpty()) {
                    event.tags(RiemannReporter.this.tags);
                }
                StringBuilder sb = new StringBuilder();
                if (prefix != null) {
                    sb.append(prefix);
                    sb.append(separator);
                }
                sb.append(metricName);
                for (String part : components) {
                    sb.append(separator);
                    sb.append(part);
                }
                event.service(sb.toString());
                event.time(timestamp);
                event.attribute("metric-type", metricType);
                return event;
            }
        };
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        long timestamp = this.clock.getTime() / 1000L;
        log.debug("Reporting metrics: for {} at {}", (Object)timestamp, (Object)System.currentTimeMillis());
        try {
            this.riemann.connect();
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                this.reportGauge(entry.getKey(), entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
                this.reportCounter(entry.getKey(), (Counter)entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
                this.reportHistogram(entry.getKey(), (Histogram)entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
                this.reportMetered(entry.getKey(), (Metered)entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
                this.reportTimer(entry.getKey(), (Timer)entry.getValue(), timestamp);
            }
            log.trace("Flushing events to riemann");
            this.riemann.client.flush();
            log.debug("Completed at {}", (Object)System.currentTimeMillis());
        }
        catch (IOException e) {
            log.warn("Unable to report to Riemann", (Object)this.riemann, (Object)e);
        }
    }

    public void stop() {
        try {
            super.stop();
        }
        finally {
            try {
                this.riemann.close();
            }
            catch (IOException e) {
                log.debug("Error disconnecting from Riemann", (Object)this.riemann, (Object)e);
            }
        }
    }

    private void reportTimer(String name, Timer timer, long timestamp) {
        Snapshot snapshot = timer.getSnapshot();
        EventClosure reporter = this.newEvent(name, timestamp, timer.getClass().getSimpleName());
        TimeUnit timeUnit = TimeUnit.valueOf(this.getDurationUnit().toUpperCase());
        reporter.name("max").metric(this.convertDuration(snapshot.getMax())).state(this.valueFilterMap.state(timer, "max", timeUnit)).send();
        reporter.name("mean").metric(this.convertDuration(snapshot.getMean())).state(this.valueFilterMap.state(timer, "mean", timeUnit)).send();
        reporter.name("min").metric(this.convertDuration(snapshot.getMin())).state(this.valueFilterMap.state(timer, "min", timeUnit)).send();
        reporter.name("stddev").metric(this.convertDuration(snapshot.getStdDev())).state(this.valueFilterMap.state(timer, "stddev", timeUnit)).send();
        reporter.name("p50").metric(this.convertDuration(snapshot.getMedian())).state(this.valueFilterMap.state(timer, "p50", timeUnit)).send();
        reporter.name("p75").metric(this.convertDuration(snapshot.get75thPercentile())).state(this.valueFilterMap.state(timer, "p75", timeUnit)).send();
        reporter.name("p95").metric(this.convertDuration(snapshot.get95thPercentile())).state(this.valueFilterMap.state(timer, "p95", timeUnit)).send();
        reporter.name("p98").metric(this.convertDuration(snapshot.get98thPercentile())).state(this.valueFilterMap.state(timer, "p98", timeUnit)).send();
        reporter.name("p99").metric(this.convertDuration(snapshot.get99thPercentile())).state(this.valueFilterMap.state(timer, "p99", timeUnit)).send();
        reporter.name("p999").metric(this.convertDuration(snapshot.get999thPercentile())).state(this.valueFilterMap.state(timer, "p999", timeUnit)).send();
        this.reportMetered(name, (Metered)timer, timestamp);
    }

    private void reportMetered(String name, Metered meter, long timestamp) {
        EventClosure reporter = this.newEvent(name, timestamp, meter.getClass().getSimpleName());
        reporter.name("count").metric(meter.getCount()).state(this.valueFilterMap.state(meter, "count")).send();
        reporter.name("m1_rate").metric(this.convertRate(meter.getOneMinuteRate())).state(this.valueFilterMap.state(meter, "m1_rate")).send();
        reporter.name("m5_rate").metric(this.convertRate(meter.getFiveMinuteRate())).state(this.valueFilterMap.state(meter, "m5_rate")).send();
        reporter.name("m15_rate").metric(this.convertRate(meter.getFifteenMinuteRate())).state(this.valueFilterMap.state(meter, "m15_rate")).send();
        reporter.name("mean_rate").metric(this.convertRate(meter.getMeanRate())).state(this.valueFilterMap.state(meter, "mean_rate")).send();
    }

    private void reportHistogram(String name, Histogram histogram, long timestamp) {
        Snapshot snapshot = histogram.getSnapshot();
        EventClosure reporter = this.newEvent(name, timestamp, histogram.getClass().getSimpleName());
        reporter.name("count").metric(histogram.getCount()).state(this.valueFilterMap.state(histogram, "count")).send();
        reporter.name("max").metric(snapshot.getMax()).state(this.valueFilterMap.state(histogram, "max")).send();
        reporter.name("mean").metric(snapshot.getMean()).state(this.valueFilterMap.state(histogram, "mean")).send();
        reporter.name("min").metric(snapshot.getMin()).state(this.valueFilterMap.state(histogram, "min")).send();
        reporter.name("stddev").metric(snapshot.getStdDev()).state(this.valueFilterMap.state(histogram, "stddev")).send();
        reporter.name("p50").metric(snapshot.getMedian()).state(this.valueFilterMap.state(histogram, "p50")).send();
        reporter.name("p75").metric(snapshot.get75thPercentile()).state(this.valueFilterMap.state(histogram, "p75")).send();
        reporter.name("p95").metric(snapshot.get95thPercentile()).state(this.valueFilterMap.state(histogram, "max")).send();
        reporter.name("p98").metric(snapshot.get98thPercentile()).state(this.valueFilterMap.state(histogram, "p95")).send();
        reporter.name("p99").metric(snapshot.get99thPercentile()).state(this.valueFilterMap.state(histogram, "p99")).send();
        reporter.name("p999").metric(snapshot.get999thPercentile()).state(this.valueFilterMap.state(histogram, "p999")).send();
    }

    private void reportCounter(String name, Counter counter, long timestamp) {
        EventClosure reporter = this.newEvent(name, timestamp, counter.getClass().getSimpleName());
        reporter.name("count").metric(counter.getCount()).state(this.valueFilterMap.state(counter)).send();
    }

    private void reportGauge(String name, Gauge gauge, long timestamp) {
        EventClosure reporter = this.newEvent(name, timestamp, gauge.getClass().getSimpleName());
        Object o = gauge.getValue();
        if (o instanceof Float) {
            reporter.name(new String[0]).metric(((Float)o).floatValue()).send();
        } else if (o instanceof Double) {
            reporter.name(new String[0]).metric(((Double)o).doubleValue()).send();
        } else if (o instanceof Byte) {
            reporter.name(new String[0]).metric(((Byte)o).byteValue()).send();
        } else if (o instanceof Short) {
            reporter.name(new String[0]).metric(((Short)o).shortValue()).send();
        } else if (o instanceof Integer) {
            reporter.name(new String[0]).metric(((Integer)o).intValue()).send();
        } else if (o instanceof Long) {
            reporter.name(new String[0]).metric(((Long)o).longValue()).send();
        } else if (o == null) {
            log.debug("Gauge {} has a null value", (Object)name);
        } else {
            log.debug("Gauge {} was of an unknown type: {} ", (Object)name, (Object)o.getClass().toString());
        }
    }

    private static interface EventClosure {
        public EventDSL name(String ... var1);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Clock clock;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private Float ttl;
        private String prefix;
        private String separator;
        private String localHost;
        private final List<String> tags;
        private ValueFilterMap valueFilterMap = new ValueFilterMap();

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
            this.ttl = null;
            this.tags = new ArrayList<String>();
            this.prefix = null;
            this.separator = " ";
            try {
                this.localHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.localHost = null;
            }
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder withTtl(Float ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder useSeparator(String separator) {
            this.separator = separator;
            return this;
        }

        public Builder localHost(String localHost) {
            this.localHost = localHost;
            return this;
        }

        public Builder tags(Collection<String> tags) {
            this.tags.clear();
            this.tags.addAll(tags);
            return this;
        }

        public Builder withValueFilterMap(ValueFilterMap valueFilterMap) {
            this.valueFilterMap = valueFilterMap;
            return this;
        }

        public RiemannReporter build(Riemann riemann) {
            return new RiemannReporter(this.registry, riemann, this.clock, this.rateUnit, this.durationUnit, this.ttl, this.prefix, this.separator, this.localHost, this.tags, this.filter, this.valueFilterMap);
        }
    }
}

