/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.riemann;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.codahale.metrics.riemann.ValueFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class ValueFilterMap {
    public static final String MAX = "max";
    public static final String MEAN = "mean";
    public static final String MIN = "min";
    public static final String STDDEV = "stddev";
    public static final String P50 = "p50";
    public static final String P75 = "p75";
    public static final String P95 = "p95";
    public static final String P98 = "p98";
    public static final String P99 = "p99";
    public static final String P999 = "p999";
    public static final String COUNT = "count";
    public static final String M1_RATE = "m1_rate";
    public static final String M5_RATE = "m5_rate";
    public static final String M15_RATE = "m15_rate";
    public static final String MEAN_RATE = "mean_rate";
    private static final Map<String, SnapValue> snapValueMap = new HashMap<String, SnapValue>();
    private static final Map<String, MeteredValue> meteredValueMap = new HashMap<String, MeteredValue>();
    private final Map<Metric, Map<String, List<ValueFilter>>> filterMapMap = new ConcurrentHashMap<Metric, Map<String, List<ValueFilter>>>();

    static {
        snapValueMap.put(MAX, new SnapValue(){

            @Override
            public double value(Snapshot snapshot) {
                return snapshot.getMax();
            }
        });
        snapValueMap.put(MEAN, new SnapValue(){

            @Override
            public double value(Snapshot snapshot) {
                return snapshot.getMean();
            }
        });
        snapValueMap.put(MIN, new SnapValue(){

            @Override
            public double value(Snapshot snapshot) {
                return snapshot.getMin();
            }
        });
        snapValueMap.put(STDDEV, new SnapValue(){

            @Override
            public double value(Snapshot snapshot) {
                return snapshot.getStdDev();
            }
        });
        snapValueMap.put(P50, new SnapValue(){

            @Override
            public double value(Snapshot snapshot) {
                return snapshot.getMedian();
            }
        });
        snapValueMap.put(P75, new SnapValue(){

            @Override
            public double value(Snapshot snapshot) {
                return snapshot.get75thPercentile();
            }
        });
        snapValueMap.put(P95, new SnapValue(){

            @Override
            public double value(Snapshot snapshot) {
                return snapshot.get95thPercentile();
            }
        });
        snapValueMap.put(P98, new SnapValue(){

            @Override
            public double value(Snapshot snapshot) {
                return snapshot.get98thPercentile();
            }
        });
        snapValueMap.put(P99, new SnapValue(){

            @Override
            public double value(Snapshot snapshot) {
                return snapshot.get99thPercentile();
            }
        });
        snapValueMap.put(P999, new SnapValue(){

            @Override
            public double value(Snapshot snapshot) {
                return snapshot.get999thPercentile();
            }
        });
        meteredValueMap.put(COUNT, new MeteredValue(){

            @Override
            public double value(Metered metered) {
                return metered.getCount();
            }
        });
        meteredValueMap.put(M1_RATE, new MeteredValue(){

            @Override
            public double value(Metered metered) {
                return metered.getOneMinuteRate();
            }
        });
        meteredValueMap.put(M5_RATE, new MeteredValue(){

            @Override
            public double value(Metered metered) {
                return metered.getFiveMinuteRate();
            }
        });
        meteredValueMap.put(M15_RATE, new MeteredValue(){

            @Override
            public double value(Metered metered) {
                return metered.getFifteenMinuteRate();
            }
        });
        meteredValueMap.put(MEAN_RATE, new MeteredValue(){

            @Override
            public double value(Metered metered) {
                return metered.getMeanRate();
            }
        });
    }

    public ValueFilterMap addFilter(Metric metric, String measure, ValueFilter filter) {
        List<ValueFilter> filterList;
        Map<String, List<ValueFilter>> filterMap = this.filterMapMap.get(metric);
        if (filterMap == null) {
            filterMap = new HashMap<String, List<ValueFilter>>();
            this.filterMapMap.put(metric, filterMap);
        }
        if ((filterList = filterMap.get(measure)) == null) {
            filterList = new ArrayList<ValueFilter>();
            filterMap.put(measure, filterList);
        }
        filterList.add(filter);
        return this;
    }

    public List<ValueFilter> getFilterList(Metric metric, String measure) {
        Map<String, List<ValueFilter>> filterMap = this.filterMapMap.get(metric);
        if (filterMap == null) {
            return null;
        }
        return filterMap.get(measure);
    }

    public String state(Timer timer, String measure, TimeUnit durationUnit) {
        Snapshot snap = timer.getSnapshot();
        double value = snapValueMap.get(measure).value(snap) / (double)durationUnit.toNanos(1L);
        return this.state(this.getFilterList((Metric)timer, measure), value);
    }

    public String state(Histogram histogram, String measure) {
        double value;
        if (measure.equals(COUNT)) {
            value = histogram.getCount();
        } else {
            Snapshot snap = histogram.getSnapshot();
            value = snapValueMap.get(measure).value(snap);
        }
        return this.state(this.getFilterList((Metric)histogram, measure), value);
    }

    public String state(Metered metered, String measure) {
        double value = meteredValueMap.get(measure).value(metered);
        return this.state(this.getFilterList((Metric)metered, measure), value);
    }

    public String state(Counter counter) {
        double value = counter.getCount();
        return this.state(this.getFilterList((Metric)counter, COUNT), value);
    }

    public synchronized void clear(Metric metric) {
        Map<String, List<ValueFilter>> filters = this.filterMapMap.get(metric);
        for (Map.Entry<String, List<ValueFilter>> entry : filters.entrySet()) {
            entry.getValue().clear();
        }
        filters.clear();
    }

    public synchronized void clear() {
        for (Metric metric : this.filterMapMap.keySet()) {
            this.clear(metric);
        }
    }

    private String state(List<ValueFilter> filters, double value) {
        String ret = "ok";
        if (filters != null) {
            for (ValueFilter filter : filters) {
                if (!filter.applies(value)) continue;
                ret = filter.getState();
            }
        }
        return ret;
    }

    static interface MeteredValue {
        public double value(Metered var1);
    }

    static interface SnapValue {
        public double value(Snapshot var1);
    }
}

