/*
 * Decompiled with CFR 0.152.
 */
package io.riemann.riemann.client;

import io.riemann.riemann.client.Fn2;
import io.riemann.riemann.client.IPromise;
import io.riemann.riemann.client.MapPromise;
import io.riemann.riemann.client.Promise;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class ChainPromise<T>
implements IPromise<T> {
    public final IPromise<IPromise<T>> inner = new Promise<IPromise<T>>();

    public void attach(IPromise<T> innerValue) {
        this.inner.deliver(innerValue);
    }

    @Override
    public void deliver(Object value) {
        throw new UnsupportedOperationException("Can't deliver to a chained promise.; deliver to the underlying promise instead?");
    }

    @Override
    public T deref() throws IOException {
        return this.inner.deref().deref();
    }

    @Override
    public T deref(long time, TimeUnit unit) throws IOException {
        return this.deref(time, unit, null);
    }

    @Override
    public T deref(long time, TimeUnit unit, T timeoutValue) throws IOException {
        return (T)this.unsafeDeref(time, unit, timeoutValue);
    }

    @Override
    public Object deref(long millis, Object timeoutValue) throws IOException {
        return this.unsafeDeref(millis, TimeUnit.MILLISECONDS, timeoutValue);
    }

    @Override
    public Object unsafeDeref(long time, TimeUnit unit, Object timeoutValue) throws IOException {
        long t1 = System.nanoTime();
        Object attached = this.inner.unsafeDeref(time, unit, timeoutValue);
        if (timeoutValue == attached) {
            return timeoutValue;
        }
        long remainingNanos = t1 + unit.toNanos(time) - System.nanoTime();
        return ((IPromise)attached).unsafeDeref(remainingNanos, TimeUnit.NANOSECONDS, timeoutValue);
    }

    @Override
    public <T2> IPromise<T2> map(Fn2<T, T2> f) {
        return new MapPromise<T, T2>(this, f);
    }
}

