/*
 * Decompiled with CFR 0.152.
 */
package io.riemann.riemann.client;

import io.riemann.riemann.client.Fn2;
import io.riemann.riemann.client.IPromise;
import io.riemann.riemann.client.MapPromise;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class Promise<T>
implements IPromise<T> {
    public final CountDownLatch latch = new CountDownLatch(1);
    public final AtomicReference ref = new AtomicReference<CountDownLatch>(this.latch);

    public static Object rehydrate(Object value) throws IOException {
        if (value instanceof IOException) {
            throw (IOException)value;
        }
        if (value instanceof RuntimeException) {
            throw (RuntimeException)value;
        }
        return value;
    }

    @Override
    public void deliver(Object value) {
        if (0L < this.latch.getCount() && this.ref.compareAndSet(this.latch, value)) {
            this.latch.countDown();
        }
    }

    @Override
    public T deref() throws IOException {
        try {
            this.latch.await();
            return (T)Promise.rehydrate(this.ref.get());
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public T deref(long time, TimeUnit unit) throws IOException {
        return this.deref(time, unit, null);
    }

    @Override
    public T deref(long time, TimeUnit unit, T timeoutValue) throws IOException {
        return (T)this.unsafeDeref(time, unit, timeoutValue);
    }

    @Override
    public Object deref(long millis, Object timeoutValue) throws IOException {
        return this.unsafeDeref(millis, TimeUnit.MILLISECONDS, timeoutValue);
    }

    @Override
    public Object unsafeDeref(long time, TimeUnit unit, Object timeoutValue) throws IOException {
        try {
            if (this.latch.await(time, unit)) {
                return Promise.rehydrate(this.ref.get());
            }
            return timeoutValue;
        }
        catch (InterruptedException e) {
            return timeoutValue;
        }
    }

    @Override
    public <T2> IPromise<T2> map(Fn2<T, T2> f) {
        return new MapPromise<T, T2>(this, f);
    }
}

