/*
 * Decompiled with CFR 0.152.
 */
package io.riemann.riemann.client;

import com.google.protobuf.MessageLite;
import io.riemann.riemann.Proto;
import io.riemann.riemann.client.AsynchronousTransport;
import io.riemann.riemann.client.CachingResolver;
import io.riemann.riemann.client.ChannelGroupHandler;
import io.riemann.riemann.client.ExceptionReporter;
import io.riemann.riemann.client.HashedWheelTimerFactory;
import io.riemann.riemann.client.IPromise;
import io.riemann.riemann.client.OverloadedException;
import io.riemann.riemann.client.Promise;
import io.riemann.riemann.client.ReconnectHandler;
import io.riemann.riemann.client.Resolver;
import io.riemann.riemann.client.TcpHandler;
import io.riemann.riemann.client.Transport;
import io.riemann.riemann.client.Write;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.jboss.netty.handler.codec.protobuf.ProtobufDecoder;
import org.jboss.netty.handler.codec.protobuf.ProtobufEncoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpTransport
implements AsynchronousTransport {
    public final Logger logger = LoggerFactory.getLogger(TcpTransport.class);
    public static final ProtobufDecoder pbDecoder = new ProtobufDecoder((MessageLite)Proto.Msg.getDefaultInstance());
    public static final ProtobufEncoder pbEncoder = new ProtobufEncoder();
    public static final LengthFieldPrepender frameEncoder = new LengthFieldPrepender(4);
    public static final int DEFAULT_PORT = 5555;
    public volatile State state = State.DISCONNECTED;
    public final ChannelGroup channels = new DefaultChannelGroup();
    public volatile Timer timer;
    public volatile ClientBootstrap bootstrap;
    public volatile Semaphore writeLimiter = new Semaphore(8192);
    public final AtomicInteger writeLimit = new AtomicInteger(8192);
    public final AtomicLong reconnectDelay = new AtomicLong(5000L);
    public final AtomicInteger connectTimeout = new AtomicInteger(5000);
    public final AtomicInteger writeTimeout = new AtomicInteger(5000);
    public final AtomicInteger writeBufferHigh = new AtomicInteger(65536);
    public final AtomicInteger writeBufferLow = new AtomicInteger(8192);
    public final AtomicBoolean cacheDns = new AtomicBoolean(true);
    public final InetSocketAddress address;
    public final AtomicReference<SSLContext> sslContext = new AtomicReference();
    public volatile ExceptionReporter exceptionReporter = new ExceptionReporter(){

        @Override
        public void reportException(Throwable t) {
        }
    };

    public void setExceptionReporter(ExceptionReporter exceptionReporter) {
        this.exceptionReporter = exceptionReporter;
    }

    public TcpTransport(InetSocketAddress address) {
        this.address = address;
    }

    public TcpTransport(String host, int port) throws IOException {
        this(new InetSocketAddress(host, port));
    }

    public TcpTransport(String host) throws IOException {
        this(host, 5555);
    }

    public TcpTransport(int port) throws IOException {
        this(InetAddress.getLocalHost().getHostAddress(), port);
    }

    public synchronized TcpTransport setWriteBufferLimit(int limit) {
        if (this.isConnected()) {
            throw new IllegalStateException("can't modify the write buffer limit of a connected transport; please set the limit before connecting");
        }
        this.writeLimit.set(limit);
        this.writeLimiter = new Semaphore(limit);
        return this;
    }

    @Override
    public boolean isConnected() {
        if (this.state != State.CONNECTED) {
            return false;
        }
        for (Channel ch : this.channels) {
            if (!ch.isConnected()) continue;
            return true;
        }
        return false;
    }

    public SslHandler sslHandler() {
        SSLContext context = this.sslContext.get();
        if (context == null) {
            return null;
        }
        SSLEngine engine = context.createSSLEngine();
        engine.setUseClientMode(true);
        SslHandler handler = new SslHandler(engine);
        handler.setEnableRenegotiation(false);
        handler.setIssueHandshake(true);
        return handler;
    }

    @Override
    public synchronized void connect() throws IOException {
        if (this.state != State.DISCONNECTED) {
            return;
        }
        this.state = State.CONNECTING;
        NioClientSocketChannelFactory channelFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        this.timer = HashedWheelTimerFactory.CreateDaemonHashedWheelTimer();
        this.bootstrap = new ClientBootstrap((ChannelFactory)channelFactory);
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() {
                ChannelPipeline p = Channels.pipeline();
                p.addLast("reconnect", (ChannelHandler)new ReconnectHandler(TcpTransport.this.bootstrap, TcpTransport.this.timer, TcpTransport.this.reconnectDelay, TimeUnit.MILLISECONDS));
                SslHandler sslHandler = TcpTransport.this.sslHandler();
                if (sslHandler != null) {
                    p.addLast("tls", (ChannelHandler)sslHandler);
                }
                p.addLast("frame-decoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4));
                p.addLast("frame-encoder", (ChannelHandler)frameEncoder);
                p.addLast("protobuf-decoder", (ChannelHandler)pbDecoder);
                p.addLast("protobuf-encoder", (ChannelHandler)pbEncoder);
                p.addLast("channelgroups", (ChannelHandler)new ChannelGroupHandler(TcpTransport.this.channels));
                p.addLast("handler", (ChannelHandler)new TcpHandler(TcpTransport.this.exceptionReporter));
                return p;
            }
        });
        Resolver resolver = this.cacheDns.get() ? new CachingResolver(this.address) : new Resolver(this.address);
        this.bootstrap.setOption("tcpNoDelay", (Object)true);
        this.bootstrap.setOption("keepAlive", (Object)true);
        this.bootstrap.setOption("connectTimeoutMillis", (Object)this.connectTimeout.get());
        this.bootstrap.setOption("writeBufferLowWaterMark", (Object)this.writeBufferLow.get());
        this.bootstrap.setOption("writeBufferHighWaterMark", (Object)this.writeBufferHigh.get());
        this.bootstrap.setOption("resolver", (Object)resolver);
        this.bootstrap.setOption("remoteAddress", (Object)resolver.resolve());
        ChannelFuture result = this.bootstrap.connect().awaitUninterruptibly();
        this.state = State.CONNECTED;
        if (!result.isSuccess()) {
            throw new IOException("Connection failed", result.getCause());
        }
    }

    @Override
    public void close() {
        this.close(false);
    }

    public synchronized void close(boolean force) {
        if (!force && this.state != State.CONNECTED) {
            return;
        }
        try {
            this.timer.stop();
            this.channels.close().awaitUninterruptibly();
            this.bootstrap.releaseExternalResources();
        }
        finally {
            this.timer = null;
            this.bootstrap = null;
            this.state = State.DISCONNECTED;
        }
    }

    @Override
    public synchronized void reconnect() throws IOException {
        this.close();
        this.connect();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public IPromise<Proto.Msg> sendMessage(Proto.Msg msg) {
        return this.sendMessage(msg, new Promise<Proto.Msg>());
    }

    public Promise<Proto.Msg> sendMessage(Proto.Msg msg, Promise<Proto.Msg> promise) {
        if (this.state != State.CONNECTED) {
            promise.deliver(new IOException("client not connected"));
            return promise;
        }
        Write write = new Write(msg, promise);
        final Semaphore limiter = this.writeLimiter;
        if (limiter.tryAcquire()) {
            Iterator iterator = this.channels.iterator();
            if (iterator.hasNext()) {
                Channel channel = (Channel)iterator.next();
                ChannelFuture f = channel.write((Object)write);
                f.addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture f) {
                        limiter.release();
                    }
                });
                return promise;
            }
            limiter.release();
            promise.deliver(new IOException("no channels available"));
            return promise;
        }
        promise.deliver(new OverloadedException("client write buffer is full: " + this.writeLimiter.availablePermits() + " / " + this.writeLimit.get() + " messages."));
        return promise;
    }

    @Override
    public Transport transport() {
        return null;
    }

    public static enum State {
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        DISCONNECTING;

    }
}

