/*
 * Decompiled with CFR 0.152.
 */
package io.riemann.riemann.client;

import io.riemann.riemann.Proto;
import io.riemann.riemann.client.AsynchronizeTransport;
import io.riemann.riemann.client.AsynchronousTransport;
import io.riemann.riemann.client.EventDSL;
import io.riemann.riemann.client.Fn2;
import io.riemann.riemann.client.IPromise;
import io.riemann.riemann.client.IRiemannClient;
import io.riemann.riemann.client.MsgValidator;
import io.riemann.riemann.client.RiemannScheduler;
import io.riemann.riemann.client.SynchronousTransport;
import io.riemann.riemann.client.TcpTransport;
import io.riemann.riemann.client.Transport;
import io.riemann.riemann.client.UdpTransport;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class RiemannClient
implements IRiemannClient {
    public static final MsgValidator validate = new MsgValidator();
    public volatile RiemannScheduler scheduler = null;
    public final AsynchronousTransport transport;

    public static IPromise<Proto.Msg> sendException(IRiemannClient client, String service, Throwable t) {
        StringBuilder desc = new StringBuilder();
        desc.append(t.toString());
        desc.append("\n\n");
        for (StackTraceElement e : t.getStackTrace()) {
            desc.append(e);
            desc.append("\n");
        }
        return client.event().service(service).state("error").tag("exception").tag(t.getClass().getSimpleName()).description(desc.toString()).send();
    }

    public static RiemannClient wrap(SynchronousTransport t) {
        return new RiemannClient(t);
    }

    public static RiemannClient wrap(AsynchronousTransport t) {
        return new RiemannClient(t);
    }

    public static RiemannClient tcp(InetSocketAddress remoteAddress) throws IOException {
        return RiemannClient.wrap(new TcpTransport(remoteAddress));
    }

    public static RiemannClient tcp(InetSocketAddress remoteAddress, InetSocketAddress localAddress) throws IOException {
        return RiemannClient.wrap(new TcpTransport(remoteAddress, localAddress));
    }

    public static RiemannClient tcp(String remoteHost, int remotePort) throws IOException {
        return RiemannClient.wrap(new TcpTransport(remoteHost, remotePort));
    }

    public static RiemannClient tcp(String remoteHost, int remotePort, String localHost, int localPort) throws IOException {
        return RiemannClient.wrap(new TcpTransport(remoteHost, remotePort, localHost, localPort));
    }

    public static RiemannClient tcp(String remoteHost) throws IOException {
        return RiemannClient.wrap(new TcpTransport(remoteHost));
    }

    public static RiemannClient tcp(String remoteHost, String localHost) throws IOException {
        return RiemannClient.wrap(new TcpTransport(remoteHost, localHost));
    }

    public static RiemannClient tcp(int remotePort) throws IOException {
        return RiemannClient.wrap(new TcpTransport(remotePort));
    }

    public static RiemannClient udp(InetSocketAddress remoteAddress) throws IOException {
        return RiemannClient.wrap(new UdpTransport(remoteAddress));
    }

    public static RiemannClient udp(InetSocketAddress remoteAddress, InetSocketAddress localAddress) throws IOException {
        return RiemannClient.wrap(new UdpTransport(remoteAddress, localAddress));
    }

    public static RiemannClient udp(String remoteHost, int remotePort) throws IOException {
        return RiemannClient.wrap(new UdpTransport(remoteHost, remotePort));
    }

    public static RiemannClient udp(String remoteHost, int remotePort, String localHost, int localPort) throws IOException {
        return RiemannClient.wrap(new UdpTransport(remoteHost, remotePort, localHost, localPort));
    }

    public static RiemannClient udp(String remoteHost) throws IOException {
        return RiemannClient.wrap(new UdpTransport(remoteHost));
    }

    public static RiemannClient udp(String remoteHost, String localHost) throws IOException {
        return RiemannClient.wrap(new UdpTransport(remoteHost, localHost));
    }

    public static RiemannClient udp(int remotePort) throws IOException {
        return RiemannClient.wrap(new UdpTransport(remotePort));
    }

    public RiemannClient(SynchronousTransport t) {
        this(new AsynchronizeTransport(t));
    }

    public RiemannClient(AsynchronousTransport t) {
        this.transport = t;
    }

    @Override
    public EventDSL event() {
        return new EventDSL(this);
    }

    @Override
    public IPromise<Proto.Msg> sendMessage(Proto.Msg m) {
        return this.transport.sendMessage(m).map(validate);
    }

    @Override
    public IPromise<Proto.Msg> sendEvent(Proto.Event event) {
        return this.sendMessage(Proto.Msg.newBuilder().addEvents(event).build());
    }

    @Override
    public IPromise<Proto.Msg> sendEvents(Proto.Event ... events) {
        return this.sendEvents(Arrays.asList(events));
    }

    @Override
    public IPromise<Proto.Msg> sendEvents(List<Proto.Event> events) {
        return this.sendMessage(Proto.Msg.newBuilder().addAllEvents(events).build());
    }

    @Override
    public IPromise<Proto.Msg> sendException(String service, Throwable t) {
        return RiemannClient.sendException(this, service, t);
    }

    @Override
    public IPromise<List<Proto.Event>> query(String q) {
        return this.sendMessage(Proto.Msg.newBuilder().setQuery(Proto.Query.newBuilder().setString(q).build()).build()).map(new Fn2<Proto.Msg, List<Proto.Event>>(){

            @Override
            public List<Proto.Event> call(Proto.Msg m) {
                return Collections.unmodifiableList(m.getEventsList());
            }
        });
    }

    @Override
    public Transport transport() {
        return this.transport;
    }

    @Override
    public void connect() throws IOException {
        this.transport.connect();
    }

    @Override
    public boolean isConnected() {
        return this.transport.isConnected();
    }

    @Override
    public void close() {
        this.transport.close();
    }

    @Override
    public void reconnect() throws IOException {
        this.transport.reconnect();
    }

    @Override
    public void flush() throws IOException {
        this.transport.flush();
    }

    public synchronized RiemannScheduler scheduler() {
        if (this.scheduler == null) {
            this.scheduler = new RiemannScheduler(this);
        }
        return this.scheduler;
    }
}

