/*
 * Decompiled with CFR 0.152.
 */
package io.riemann.riemann.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.timeout.ReadTimeoutException;
import java.net.ConnectException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class ReconnectHandler
extends ChannelInboundHandlerAdapter {
    private final Bootstrap bootstrap;
    private final ChannelGroup channels;
    public long startTime = -1L;
    public final AtomicLong delay;
    public final TimeUnit unit;

    public ReconnectHandler(Bootstrap bootstrap, ChannelGroup channels, AtomicLong delay, TimeUnit unit) {
        this.bootstrap = bootstrap;
        this.channels = channels;
        this.delay = delay;
        this.unit = unit;
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        try {
            ctx.executor().schedule(new Runnable(){

                @Override
                public void run() {
                    ChannelFuture channelFuture = ReconnectHandler.this.bootstrap.connect();
                    ReconnectHandler.this.channels.add((Object)channelFuture.channel());
                }
            }, this.delay.get(), this.unit);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        super.channelInactive(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.startTime < 0L) {
            this.startTime = System.currentTimeMillis();
        }
        super.channelActive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        Throwable cause = e.getCause();
        if (cause instanceof ConnectException) {
            this.startTime = -1L;
        } else if (!(cause instanceof ReadTimeoutException)) {
            ctx.write((Object)e);
        }
        ctx.channel().close();
    }
}

