/*
 * Decompiled with CFR 0.152.
 */
package io.riemann.riemann.client;

import io.riemann.riemann.Proto;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventBuilder {
    private final Proto.Event.Builder builder;
    private final Map<String, String> attributes = new HashMap<String, String>();

    public EventBuilder() {
        this.builder = Proto.Event.newBuilder();
    }

    public EventBuilder host(String host) {
        if (null == host) {
            this.builder.clearHost();
        } else {
            this.builder.setHost(host);
        }
        return this;
    }

    public EventBuilder service(String service) {
        if (null == service) {
            this.builder.clearService();
        } else {
            this.builder.setService(service);
        }
        return this;
    }

    public EventBuilder state(String state) {
        if (null == state) {
            this.builder.clearState();
        } else {
            this.builder.setState(state);
        }
        return this;
    }

    public EventBuilder description(String description) {
        if (null == description) {
            this.builder.clearDescription();
        } else {
            this.builder.setDescription(description);
        }
        return this;
    }

    public EventBuilder time() {
        this.builder.clearTime();
        this.builder.clearTimeMicros();
        return this;
    }

    public EventBuilder time(float time) {
        this.builder.setTime((long)time);
        this.builder.setTimeMicros((long)(time * 1000000.0f));
        return this;
    }

    public EventBuilder time(double time) {
        this.builder.setTime((long)time);
        this.builder.setTimeMicros((long)(time * 1000000.0));
        return this;
    }

    public EventBuilder time(long time) {
        this.builder.setTime(time);
        return this;
    }

    public EventBuilder metric() {
        this.builder.clearMetricF();
        this.builder.clearMetricD();
        this.builder.clearMetricSint64();
        return this;
    }

    public EventBuilder metric(byte metric) {
        this.builder.setMetricSint64(metric);
        this.builder.setMetricF(metric);
        return this;
    }

    public EventBuilder metric(short metric) {
        this.builder.setMetricSint64(metric);
        this.builder.setMetricF(metric);
        return this;
    }

    public EventBuilder metric(int metric) {
        this.builder.setMetricSint64(metric);
        this.builder.setMetricF(metric);
        return this;
    }

    public EventBuilder metric(long metric) {
        this.builder.setMetricSint64(metric);
        this.builder.setMetricF(metric);
        return this;
    }

    public EventBuilder metric(float metric) {
        this.builder.setMetricF(metric);
        return this;
    }

    public EventBuilder metric(double metric) {
        this.builder.setMetricD(metric);
        this.builder.setMetricF((float)metric);
        return this;
    }

    public EventBuilder tag(String tag) {
        this.builder.addTags(tag);
        return this;
    }

    public EventBuilder tags(List<String> tags) {
        this.builder.addAllTags(tags);
        return this;
    }

    public EventBuilder tags(String ... tags) {
        this.builder.addAllTags(Arrays.asList(tags));
        return this;
    }

    public EventBuilder ttl() {
        this.builder.clearTtl();
        return this;
    }

    public EventBuilder ttl(float ttl) {
        this.builder.setTtl(ttl);
        return this;
    }

    public EventBuilder attribute(String name, String value) {
        this.attributes.put(name, value);
        return this;
    }

    public EventBuilder attributes(Map<String, String> attributes) {
        this.attributes.putAll(attributes);
        return this;
    }

    public Proto.Event build() {
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            Proto.Attribute.Builder attribBuilder = Proto.Attribute.newBuilder();
            attribBuilder.setKey(entry.getKey());
            attribBuilder.setValue(entry.getValue());
            this.builder.addAttributes(attribBuilder);
        }
        return this.builder.build();
    }
}

