/*
 * Decompiled with CFR 0.152.
 */
package io.riemann.riemann.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.riemann.riemann.Proto;
import io.riemann.riemann.client.ExceptionReporter;
import io.riemann.riemann.client.Promise;
import io.riemann.riemann.client.ReconnectHandler;
import io.riemann.riemann.client.SynchronousTransport;
import io.riemann.riemann.client.Transport;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class UdpTransport
implements SynchronousTransport {
    public static final Promise<Proto.Msg> blackhole = new Promise();
    public static final ProtobufEncoder pbEncoder = new ProtobufEncoder();
    public final DiscardHandler discardHandler = new DiscardHandler();
    public static final int DEFAULT_PORT = 5555;
    public volatile State state = State.DISCONNECTED;
    public volatile Bootstrap bootstrap;
    public final EventLoopGroup eventLoopGroup = new NioEventLoopGroup();
    public final ChannelGroup channels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    public final AtomicLong reconnectDelay = new AtomicLong(5000L);
    public final AtomicLong connectTimeout = new AtomicLong(5000L);
    public final AtomicInteger sendBufferSize = new AtomicInteger(16384);
    public final AtomicBoolean autoFlush = new AtomicBoolean(true);
    public final InetSocketAddress remoteAddress;
    public final InetSocketAddress localAddress;
    public volatile ExceptionReporter exceptionReporter = new ExceptionReporter(){

        @Override
        public void reportException(Throwable t) {
            t.printStackTrace();
        }
    };

    public void setExceptionReporter(ExceptionReporter exceptionReporter) {
        this.exceptionReporter = exceptionReporter;
    }

    public UdpTransport(InetSocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
        this.localAddress = null;
    }

    public UdpTransport(InetSocketAddress remoteAddress, InetSocketAddress localAddress) {
        this.remoteAddress = remoteAddress;
        this.localAddress = localAddress;
    }

    public UdpTransport(String host, int port) throws IOException {
        this(new InetSocketAddress(host, port));
    }

    public UdpTransport(String remoteHost, int remotePort, String localHost, int localPort) throws IOException {
        this(new InetSocketAddress(remoteHost, remotePort), new InetSocketAddress(localHost, localPort));
    }

    public UdpTransport(String remoteHost) throws IOException {
        this(remoteHost, 5555);
    }

    public UdpTransport(String remoteHost, String localHost) throws IOException {
        this(remoteHost, 5555, localHost, 0);
    }

    public UdpTransport(int port) throws IOException {
        this(InetAddress.getLocalHost().getHostAddress(), port);
    }

    @Override
    public boolean isConnected() {
        return this.state == State.CONNECTED;
    }

    @Override
    public synchronized void connect() throws IOException {
        if (this.state != State.DISCONNECTED) {
            return;
        }
        this.state = State.CONNECTING;
        this.bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(NioDatagramChannel.class);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast("reconnect", (ChannelHandler)new ReconnectHandler(UdpTransport.this.bootstrap, UdpTransport.this.channels, UdpTransport.this.reconnectDelay, TimeUnit.MILLISECONDS));
                p.addLast("protobuf-encoder", (ChannelHandler)pbEncoder);
                p.addLast("discard", (ChannelHandler)UdpTransport.this.discardHandler);
            }
        });
        this.bootstrap.remoteAddress((SocketAddress)this.remoteAddress);
        this.bootstrap.localAddress((SocketAddress)this.localAddress);
        this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.sendBufferSize.get());
        ChannelFuture result = this.bootstrap.connect();
        this.channels.add((Object)result.channel());
        result.awaitUninterruptibly();
        if (!result.isSuccess()) {
            this.close(true);
            throw new IOException("Connection failed", result.cause());
        }
        this.state = State.CONNECTED;
    }

    @Override
    public void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean force) {
        if (!force && this.state != State.CONNECTED) {
            return;
        }
        try {
            this.channels.close().awaitUninterruptibly();
        }
        finally {
            try {
                this.eventLoopGroup.shutdownGracefully();
            }
            finally {
                this.bootstrap = null;
                this.state = State.DISCONNECTED;
            }
        }
    }

    @Override
    public void reconnect() throws IOException {
        this.close();
        this.connect();
    }

    @Override
    public void flush() throws IOException {
        this.channels.flush();
    }

    @Override
    public Proto.Msg sendMessage(Proto.Msg msg) {
        if (this.autoFlush.get()) {
            this.channels.writeAndFlush((Object)msg);
        } else {
            this.channels.write((Object)msg);
        }
        return null;
    }

    @Override
    public Transport transport() {
        return null;
    }

    public class DiscardHandler
    extends ChannelInboundHandlerAdapter {
        public void channelActive(ChannelHandlerContext ctx) {
            ctx.channel().config().setAutoRead(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            try {
                UdpTransport.this.exceptionReporter.reportException(cause);
            }
            catch (Exception ee) {
            }
            finally {
                try {
                    ctx.channel().close();
                }
                catch (Exception ee) {
                    UdpTransport.this.exceptionReporter.reportException(ee);
                }
            }
        }
    }

    public static enum State {
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        DISCONNECTING;

    }
}

