(ns io.rkn.boot-jetty
  "Example tasks showing various approaches."
  {:boot/export-tasks true}
  (:require [boot.core :as boot :refer [deftask]]
            [boot.util :as util]))

(def deps
  '[[ring "1.6.1"]
    [ring/ring-jetty-adapter "1.6.1"] ])

(def server (atom nil))

(deftask jetty
  "I'm a simple task with only setup."
  [H handler       SYM  sym  "The ring handler to serve."
   p port          PORT int  "The port to listen on. (Default: 3000)"]
  ;; merge environment etc
  (boot/set-env! :dependencies #(concat % deps))
  (require 'ring.adapter.jetty)
  (let [run-jetty (resolve 'ring.adapter.jetty/run-jetty)
        port (or port "3000")
        jetty-server (run-jetty '~handler {:join? false :port port})]
    (swap! server (fn [old-server]
                    (when old-server
                      (.stop old-server))
                    jetty-server))
    (println "Launched Jetty on http://localhost:" port))
  identity)


