(ns io.rkn.boot-jetty
  "Example tasks showing various approaches."
  {:boot/export-tasks true}
  (:require [boot.core :as boot :refer [deftask]]
            [boot.util :as util]))

(def deps
  '[[ring "1.6.1"]
    [ring/ring-jetty-adapter "1.6.1"]])

(def server (atom nil))

;; From pandeiro/boot-http
(defn resolve-sym [sym]
  (require (symbol (namespace sym)) :reload)
  (resolve sym))

;; Modified from pandeiro/boot-http
(defn wrap-handler [handler reload]
  (if reload
    (let [wrap-reload (resolve-sym 'ring.middleware.reload/wrap-reload)]
      (wrap-reload (resolve-sym handler) {:dirs ["src"]}))
    (resolve-sym handler)))

(deftask jetty
  "I'm a simple task with only setup."
  [H handler       SYM  sym  "The ring handler to serve."
   p port          PORT int  "The port to listen on. (Default: 3000)"
   R reload             bool "Reload modified namespaces on each request."]
  ;; merge environment etc
  (boot/set-env! :dependencies #(concat % deps))
  (require 'ring.adapter.jetty)
  (let [run-jetty (resolve-sym 'ring.adapter.jetty/run-jetty)
        handler-fn (resolve-sym handler)
        port (or port 3000)
        jetty-server (run-jetty handler-fn {:join? false
                                            :port port})]
    (swap! server (fn [old-server]
                    (when old-server
                      (.stop old-server))
                    jetty-server))
    (println (format "Launched Jetty on http://localhost:%s" port)))
  identity)


