/*
 * Decompiled with CFR 0.152.
 */
package com.m6d.filecrush.clean;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class Clean
extends Configured
implements Tool {
    public static final String TARGET_DIR = "clean.target.dir";
    public static final String CUTTOFF_MILLIS = "clean.cutoff.millis";
    public static final String TARGET_EXPR = "clean.target.expr";
    public static final String WARN_MODE = "clean.warn.mode";
    protected FileSystem fs;
    protected Configuration conf;
    protected long cutoff;

    public static void main(String[] args) throws Exception {
        Clean clean = new Clean();
        int exitCode = ToolRunner.run((Configuration)new Configuration(), (Tool)clean, (String[])args);
        System.exit(exitCode);
    }

    public int run(String[] args) throws Exception {
        this.conf = this.getConf();
        try {
            this.fs = FileSystem.get((Configuration)this.getConf());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open filesystem");
        }
        int pre = this.preFlightCheck();
        if (pre != 0) {
            return pre;
        }
        if (this.conf.get(CUTTOFF_MILLIS) != null) {
            long now = System.currentTimeMillis();
            long targetAge = Long.parseLong(this.conf.get(CUTTOFF_MILLIS));
            this.cutoff = now - targetAge;
        }
        return this.cleanup(new Path(this.conf.get(TARGET_DIR)));
    }

    public void warnOrDelete(Path p) throws IOException {
        if (this.conf.getBoolean(WARN_MODE, false)) {
            System.out.println("DELETE " + p);
        } else if (!p.equals((Object)new Path(this.conf.get(TARGET_DIR)))) {
            this.fs.delete(p);
        }
    }

    public int cleanup(Path p) {
        try {
            if (this.fs.isFile(p)) {
                if (this.conf.get(TARGET_EXPR) != null && p.getName().matches(this.conf.get(TARGET_EXPR))) {
                    this.warnOrDelete(p);
                }
                if (this.conf.get(CUTTOFF_MILLIS) != null && this.fs.getFileStatus(p).getModificationTime() < this.cutoff) {
                    this.warnOrDelete(p);
                }
            }
            if (this.fs.isDirectory(p)) {
                for (FileStatus stat : this.fs.listStatus(p)) {
                    this.cleanup(stat.getPath());
                }
                if (this.fs.listStatus(p).length == 0) {
                    if (this.conf.get(TARGET_EXPR) != null && p.getName().matches(this.conf.get(TARGET_EXPR))) {
                        this.warnOrDelete(p);
                    }
                    if (this.conf.get(CUTTOFF_MILLIS) != null && this.fs.getFileStatus(p).getModificationTime() < this.cutoff) {
                        this.warnOrDelete(p);
                    }
                }
            }
        }
        catch (IOException e) {
            System.out.println("exception " + e);
            return 7;
        }
        return 0;
    }

    public int preFlightCheck() {
        Configuration conf = this.getConf();
        if (conf.get(TARGET_DIR) == null) {
            System.err.println("You must specify a target.dir");
            return 1;
        }
        if (conf.get(TARGET_DIR).equals("/")) {
            System.err.println("Will not clean / !!!!!!");
            return 2;
        }
        if (this.fs.getHomeDirectory().equals((Object)new Path(conf.get(TARGET_DIR)))) {
            System.err.println("Will not clean home directory");
            return 3;
        }
        if (conf.get(CUTTOFF_MILLIS) == null && conf.get(TARGET_EXPR) == null) {
            System.err.println("You must specify clean.cutoff.millis or clean.target.expr");
            return 4;
        }
        if (conf.get(CUTTOFF_MILLIS) != null && conf.get(TARGET_EXPR) != null) {
            System.err.println("You can not specify clean.cutoff.millis and clean.target.expr");
            return 9;
        }
        if (conf.get(CUTTOFF_MILLIS) != null) {
            try {
                Long.parseLong(conf.get(CUTTOFF_MILLIS));
            }
            catch (NumberFormatException ex) {
                System.err.println("clean.cutoff.millis was specified as " + conf.get(CUTTOFF_MILLIS) + " this is not a long integer");
                return 15;
            }
        }
        try {
            if (!this.fs.exists(new Path(conf.get(TARGET_DIR)))) {
                System.err.println(conf.get(TARGET_DIR) + " does not exist");
            }
        }
        catch (IOException e) {
            System.err.println("IOEXCEPTION" + e);
            return 6;
        }
        return 0;
    }
}

