/*
 * Decompiled with CFR 0.152.
 */
package com.m6d.filecrush.crush;

import java.io.DataInput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class CountersInputFormat
extends FileInputFormat<Counters, NullWritable> {
    protected boolean isSplitable(FileSystem fs, Path filename) {
        return false;
    }

    public RecordReader<Counters, NullWritable> getRecordReader(InputSplit inputSplit, JobConf jobconf, Reporter reporter) throws IOException {
        if (!(inputSplit instanceof FileSplit)) {
            throw new AssertionError();
        }
        FileSplit fSplit = (FileSplit)inputSplit;
        Path path = fSplit.getPath();
        long length = fSplit.getLength();
        FileSystem fs = FileSystem.get((Configuration)jobconf);
        FSDataInputStream is = fs.open(path);
        return new CountersReader(is, length);
    }

    private static class CountersReader
    implements RecordReader<Counters, NullWritable> {
        private final FSDataInputStream in;
        private final long length;

        public CountersReader(FSDataInputStream in, long length) {
            this.in = in;
            this.length = length;
        }

        public Counters createKey() {
            return new Counters();
        }

        public NullWritable createValue() {
            return NullWritable.get();
        }

        public long getPos() throws IOException {
            return this.in.getPos();
        }

        public float getProgress() throws IOException {
            float percent = (float)this.length / (float)this.in.getPos();
            return percent;
        }

        public boolean next(Counters key, NullWritable value) throws IOException {
            if (0L == this.in.getPos()) {
                key.readFields((DataInput)this.in);
                return true;
            }
            return false;
        }

        public void close() throws IOException {
            this.in.close();
        }
    }
}

