/*
 * Decompiled with CFR 0.152.
 */
package com.m6d.filecrush.crush;

import com.m6d.filecrush.crush.KeyValuePreservingTextInputFormat;
import com.m6d.filecrush.crush.ReducerCounter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;

public class CrushReducer
extends MapReduceBase
implements Reducer<Text, Text, Text, Text> {
    private final Text valueOut = new Text();
    private int fileNum;
    private int recordNumber;
    private int reportRecordNumber = 100;
    private int taskNum;
    private long timestamp;
    private JobConf job;
    private FileSystem fs;
    private List<Matcher> inputRegexList;
    private List<String> outputReplacementList;
    private List<Class<?>> inFormatClsList;
    private List<Class<?>> outFormatClsList;
    private Map<String, String> placeHolderToValue = new HashMap<String, String>(3);
    private Matcher placeholderMatcher = Pattern.compile("\\$\\{([a-zA-Z]([a-zA-Z\\.]*))\\}").matcher("dummy");
    private String outDirPath;
    private static final Log LOG = LogFactory.getLog(CrushReducer.class);

    public void configure(JobConf job) {
        super.configure(job);
        this.job = job;
        this.taskNum = Integer.parseInt(job.get("mapred.tip.id").replaceFirst(".+_(\\d+)", "$1"));
        this.timestamp = Long.parseLong(job.get("crush.timestamp"));
        this.outDirPath = job.get("mapred.output.dir");
        if (null == this.outDirPath || this.outDirPath.isEmpty()) {
            throw new IllegalArgumentException("mapred.output.dir has no value");
        }
        this.outDirPath = new Path(this.outDirPath + "/crush").toUri().getPath();
        int numSpecs = job.getInt("crush.num.specs", 0);
        if (numSpecs <= 0) {
            throw new IllegalArgumentException("Number of regular expressions must be zero or greater: " + numSpecs);
        }
        this.readCrushSpecs(numSpecs);
        this.placeHolderToValue.put("crush.task.num", Integer.toString(this.taskNum));
        this.placeHolderToValue.put("crush.timestamp", job.get("crush.timestamp"));
        try {
            this.fs = FileSystem.get((Configuration)job);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void readCrushSpecs(int numSpecs) {
        this.inputRegexList = new ArrayList<Matcher>(numSpecs);
        this.outputReplacementList = new ArrayList<String>(numSpecs);
        this.inFormatClsList = new ArrayList(numSpecs);
        this.outFormatClsList = new ArrayList(numSpecs);
        for (int i = 0; i < numSpecs; ++i) {
            String key = String.format("crush.%d.regex", i);
            String value = this.job.get(key);
            if (null == value || value.isEmpty()) {
                throw new IllegalArgumentException("No input regex: " + key);
            }
            this.inputRegexList.add(Pattern.compile(value).matcher("dummy"));
            key = String.format("crush.%d.regex.replacement", i);
            value = this.job.get(key);
            if (null == value || value.isEmpty()) {
                throw new IllegalArgumentException("No output replacement: " + key);
            }
            this.outputReplacementList.add(value);
            key = String.format("crush.%d.input.format", i);
            value = this.job.get(key);
            if (null == value || value.isEmpty()) {
                throw new IllegalArgumentException("No input format: " + key);
            }
            try {
                Class inFormatCls;
                if (value.equals(TextInputFormat.class.getName())) {
                    inFormatCls = KeyValuePreservingTextInputFormat.class;
                } else {
                    inFormatCls = Class.forName(value);
                    if (!FileInputFormat.class.isAssignableFrom(inFormatCls)) {
                        throw new IllegalArgumentException(String.format("Not a file input format: %s=%s", key, value));
                    }
                }
                this.inFormatClsList.add(inFormatCls);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("Not a valid class: %s=%s", key, value));
            }
            key = String.format("crush.%d.output.format", i);
            value = this.job.get(key);
            if (null == value || value.isEmpty()) {
                throw new IllegalArgumentException("No output format: " + key);
            }
            try {
                Class<?> outFormatCls = Class.forName(value);
                if (!OutputFormat.class.isAssignableFrom(outFormatCls)) {
                    throw new IllegalArgumentException(String.format("Not an output format: %s=%s", key, value));
                }
                this.outFormatClsList.add(outFormatCls);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("Not a valid class: %s=%s", key, value));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reduce(Text bucketId, Iterator<Text> values, OutputCollector<Text, Text> collector, Reporter reporter) throws IOException {
        block34: {
            String bucket = bucketId.toString();
            String dirName = bucket.substring(0, bucket.lastIndexOf(45));
            int idx = this.findMatcher(dirName);
            String outputFileName = this.calculateOutputFile(idx, dirName);
            this.valueOut.set(this.outDirPath + outputFileName);
            LOG.info((Object)String.format("Crushing bucket '%s' to file '%s'", bucket, outputFileName));
            RecordWriter<Object, Object> sink = null;
            Exception rootCause = null;
            Object key = null;
            Object value = null;
            try {
                while (null == rootCause && values.hasNext()) {
                    Text srcFile = values.next();
                    Path inputPath = new Path(srcFile.toString());
                    RecordReader<Object, Object> reader = this.createRecordReader(idx, inputPath, reporter);
                    try {
                        if (null == key) {
                            key = reader.createKey();
                            value = reader.createValue();
                            this.job.setOutputKeyClass(key.getClass());
                            this.job.setOutputValueClass(value.getClass());
                            sink = this.createRecordWriter(idx, "crush" + outputFileName);
                        } else {
                            Class<?> other = reader.createKey().getClass();
                            if (!key.getClass().equals(other)) {
                                throw new IllegalArgumentException(String.format("Heterogeneous keys detected in %s: %s !- %s", inputPath, key.getClass(), other));
                            }
                            other = reader.createValue().getClass();
                            if (!value.getClass().equals(other)) {
                                throw new IllegalArgumentException(String.format("Heterogeneous values detected in %s: %s !- %s", inputPath, value.getClass(), other));
                            }
                        }
                        while (reader.next(key, value)) {
                            sink.write(key, value);
                            reporter.incrCounter((Enum)ReducerCounter.RECORDS_CRUSHED, 1L);
                        }
                    }
                    catch (Exception e) {
                        rootCause = e;
                    }
                    finally {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {
                            if (null == rootCause) {
                                rootCause = e;
                            }
                            LOG.debug((Object)("Swallowing exception on close of " + inputPath), (Throwable)e);
                        }
                    }
                    collector.collect((Object)srcFile, (Object)this.valueOut);
                    reporter.incrCounter((Enum)ReducerCounter.FILES_CRUSHED, 1L);
                    ++this.recordNumber;
                    if (this.reportRecordNumber != this.recordNumber) continue;
                    this.reportRecordNumber += this.reportRecordNumber;
                    reporter.setStatus(String.format("Processed %,d files %s : %s", this.recordNumber, bucket, inputPath));
                }
            }
            catch (Exception e) {
                rootCause = e;
            }
            finally {
                if (null != sink) {
                    try {
                        sink.close(reporter);
                    }
                    catch (Exception e) {
                        if (null == rootCause) {
                            rootCause = e;
                        }
                        LOG.error((Object)("Swallowing exception on close of " + outputFileName), (Throwable)e);
                    }
                }
                if (null == rootCause) break block34;
                if (rootCause instanceof RuntimeException) {
                    throw (RuntimeException)rootCause;
                }
                if (rootCause instanceof IOException) {
                    throw (IOException)rootCause;
                }
                throw new RuntimeException(rootCause);
            }
        }
    }

    private RecordWriter<Object, Object> createRecordWriter(int idx, String path) throws IOException {
        Class<?> cls = this.outFormatClsList.get(idx);
        try {
            OutputFormat format = (OutputFormat)cls.newInstance();
            return format.getRecordWriter(this.fs, this.job, path, null);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private RecordReader<Object, Object> createRecordReader(int idx, Path inputPath, Reporter reporter) throws IOException {
        LOG.info((Object)String.format("Opening '%s'", inputPath));
        Class<?> cls = this.inFormatClsList.get(idx);
        try {
            InputSplit[] splits;
            FileInputFormat.setInputPaths((JobConf)this.job, (Path[])new Path[]{inputPath});
            FileInputFormat instance = (FileInputFormat)cls.newInstance();
            if (instance instanceof JobConfigurable) {
                ((JobConfigurable)instance).configure(this.job);
            }
            if (1 != (splits = instance.getSplits(this.job, 1)).length) {
                throw new IllegalArgumentException("Could not get input splits: " + inputPath);
            }
            return instance.getRecordReader(splits[0], this.job, reporter);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    String calculateOutputFile(int idx, String srcDir) {
        StringBuffer sb = new StringBuffer(srcDir);
        sb.append("/");
        String replacement = this.outputReplacementList.get(idx);
        this.placeHolderToValue.put("crush.file.num", Integer.toString(this.fileNum++));
        this.placeholderMatcher.reset(replacement);
        while (this.placeholderMatcher.find()) {
            String key = this.placeholderMatcher.group(1);
            String value = this.placeHolderToValue.get(key);
            if (null == value) {
                throw new IllegalArgumentException("No value for key: " + key);
            }
            this.placeholderMatcher.appendReplacement(sb, value);
        }
        this.placeholderMatcher.appendTail(sb);
        Matcher matcher = this.inputRegexList.get(idx);
        matcher.reset(srcDir);
        String finalOutputName = matcher.replaceAll(sb.toString());
        return finalOutputName;
    }

    int findMatcher(String dir) {
        Object outputNameWithPlaceholders = null;
        for (int i = 0; i < this.inputRegexList.size() && outputNameWithPlaceholders == null; ++i) {
            Matcher matcher = this.inputRegexList.get(i);
            matcher.reset(dir);
            if (!matcher.matches()) continue;
            return i;
        }
        throw new IllegalArgumentException("No matching input regex: " + dir);
    }

    int getTaskNum() {
        return this.taskNum;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    List<String> getInputRegexList() {
        ArrayList<String> list = new ArrayList<String>(this.inputRegexList.size());
        for (Matcher matcher : this.inputRegexList) {
            list.add(matcher.pattern().pattern());
        }
        return list;
    }

    List<String> getOutputReplacementList() {
        return new ArrayList<String>(this.outputReplacementList);
    }

    List<Class<?>> getInputFormatList() {
        return new ArrayList(this.inFormatClsList);
    }

    List<Class<?>> getOutputFormatList() {
        return new ArrayList(this.outFormatClsList);
    }
}

