/*
 * Decompiled with CFR 0.152.
 */
package com.m6d.filecrush.crush;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.LineRecordReader;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;

public class KeyValuePreservingTextInputFormat
extends FileInputFormat<Text, Text> {
    private TextInputFormat delegate;

    public void configure(JobConf conf) {
        this.delegate = new TextInputFormat();
        this.delegate.configure(conf);
    }

    protected boolean isSplitable(FileSystem fs, Path file) {
        return false;
    }

    public RecordReader<Text, Text> getRecordReader(InputSplit genericSplit, JobConf job, Reporter reporter) throws IOException {
        reporter.setStatus(genericSplit.toString());
        return new KeyValuePreservingRecordReader((RecordReader<LongWritable, Text>)new LineRecordReader((Configuration)job, (FileSplit)genericSplit));
    }

    static class KeyValuePreservingRecordReader
    implements RecordReader<Text, Text> {
        private final RecordReader<LongWritable, Text> delegate;
        private final LongWritable delKey = new LongWritable();
        private final Text delValue = new Text();

        public KeyValuePreservingRecordReader(RecordReader<LongWritable, Text> delegate) {
            this.delegate = delegate;
        }

        public Text createKey() {
            return new Text();
        }

        public Text createValue() {
            return (Text)this.delegate.createValue();
        }

        public long getPos() throws IOException {
            return this.delegate.getPos();
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public float getProgress() throws IOException {
            return this.delegate.getProgress();
        }

        public boolean next(Text key, Text value) throws IOException {
            boolean next = this.delegate.next((Object)this.delKey, (Object)this.delValue);
            if (next) {
                int first = this.delValue.find("\t");
                if (first >= 0) {
                    key.set(this.delValue.getBytes(), 0, first);
                    if (this.delValue.getLength() > first) {
                        value.set(this.delValue.getBytes(), first + 1, this.delValue.getLength() - first - 1);
                    } else {
                        value.clear();
                    }
                } else {
                    key.set(this.delValue);
                }
            }
            return next;
        }
    }
}

