/*
 * Decompiled with CFR 0.152.
 */
package starkiller;

import io.lacuna.bifurcan.IList;
import io.lacuna.bifurcan.LinearList;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    public static final Logger logger = LoggerFactory.getLogger(Util.class);

    public static Object hex(final ByteBuffer buffer) {
        return new Object(){

            public String toString() {
                StringBuilder buf = new StringBuilder();
                for (int i = buffer.position(); i < buffer.limit(); ++i) {
                    buf.append(String.format("%02x", buffer.get(i) & 0xFF));
                }
                return buf.toString();
            }
        };
    }

    public static CompletableFuture<Integer> readFully(AsynchronousSocketChannel socket, final ByteBuffer buffer) {
        if (buffer.hasRemaining()) {
            logger.trace("readFully remaining {}", (Object)buffer.remaining());
            final CompletableFuture future = new CompletableFuture();
            socket.read(buffer, null, new CompletionHandler<Integer, Object>(){

                @Override
                public void completed(Integer result, Object attachment) {
                    logger.trace("readFully read {} remaining {}", (Object)result, (Object)buffer.remaining());
                    future.complete(result);
                }

                @Override
                public void failed(Throwable exc, Object attachment) {
                    logger.warn("readFully failed", exc);
                    future.completeExceptionally(exc);
                }
            });
            return future.thenCompose(r -> Util.readFully(socket, buffer).thenApply(r2 -> r + r2));
        }
        return CompletableFuture.completedFuture(0);
    }

    public static CompletableFuture<ByteBuffer> readMessage(AsynchronousSocketChannel socket) {
        ByteBuffer lengthBuffer = ByteBuffer.allocate(2);
        return Util.readFully(socket, lengthBuffer).thenCompose(r -> {
            lengthBuffer.flip();
            int length = lengthBuffer.getShort() & 0xFFFF;
            logger.trace("read message length {}", (Object)length);
            if (length <= 16383) {
                ByteBuffer message = ByteBuffer.allocate(length);
                return Util.readFully(socket, message).thenApply(rr -> {
                    message.flip();
                    logger.trace("read message {}", Util.hex(message));
                    return message;
                });
            }
            throw new IllegalStateException("length too big: " + length);
        });
    }

    static CompletableFuture<Void> writeFully(AsynchronousSocketChannel socket, final ByteBuffer buffer) {
        if (buffer.hasRemaining()) {
            final CompletableFuture future = new CompletableFuture();
            socket.write(buffer, null, new CompletionHandler<Integer, Object>(){

                @Override
                public void completed(Integer result, Object attachment) {
                    logger.trace("wrote {}, {} remaining", (Object)result, (Object)buffer.remaining());
                    future.complete(null);
                }

                @Override
                public void failed(Throwable exc, Object attachment) {
                    future.completeExceptionally(exc);
                }
            });
            return future.thenCompose(x -> Util.writeFully(socket, buffer));
        }
        return CompletableFuture.completedFuture(null);
    }

    static class AsyncLock {
        private final String name;
        private final AtomicInteger idgen = new AtomicInteger();
        private final AtomicReference<String> locked = new AtomicReference();
        private final Atom<IList<Waiter>> waiters = new Atom<LinearList>(LinearList.of((Object[])new Waiter[0]));

        public AsyncLock(String name) {
            this.name = name;
        }

        public AsyncLock() {
            this(null);
        }

        public CompletableFuture<Locked> lock() {
            logger.trace("locking {} {}", (Object)this, (Object)this.name);
            Locked l = new Locked();
            if (this.locked.compareAndSet(null, l.id)) {
                logger.trace("locked {}", (Object)this);
                return CompletableFuture.completedFuture(l);
            }
            logger.trace("waiting for lock {}", (Object)this);
            Waiter waiter = new Waiter(l, new CompletableFuture<Locked>());
            logger.trace("waiting for lock {} with {}", (Object)this, (Object)waiter);
            this.waiters.swap(w -> w.addLast((Object)waiter));
            waiter.future.whenComplete((res, exc) -> logger.trace("waiter {} completed with res:{}, exc:{}", new Object[]{waiter, res, exc}));
            return waiter.future;
        }

        class Waiter {
            final Locked locked;
            final CompletableFuture<Locked> future;

            public Waiter(Locked locked, CompletableFuture<Locked> future) {
                this.locked = locked;
                this.future = future;
            }

            void complete() {
                this.future.complete(this.locked);
            }
        }

        class Locked {
            final String id;

            Locked() {
                this.id = String.format("%s-%d", AsyncLock.this.name != null ? AsyncLock.this.name : "lock", AsyncLock.this.idgen.incrementAndGet());
            }

            void unlock() {
                if (AsyncLock.this.locked.compareAndSet(this.id, null)) {
                    AtomicReference selected = new AtomicReference();
                    AsyncLock.this.waiters.swap(l -> {
                        if (l.size() > 0L) {
                            Waiter head = (Waiter)l.first();
                            selected.set(head);
                            return l.removeFirst();
                        }
                        return l;
                    });
                    if (selected.get() != null) {
                        if (AsyncLock.this.locked.compareAndSet(null, ((Waiter)selected.get()).locked.id)) {
                            ((Waiter)selected.get()).complete();
                        } else {
                            AsyncLock.this.waiters.swap(l -> l.addFirst((Object)((Waiter)selected.get())));
                        }
                    }
                }
            }
        }
    }

    static class Atom<T> {
        final AtomicReference<T> reference;

        public Atom(T initial) {
            this.reference = new AtomicReference<T>(initial);
        }

        Atom() {
            this(null);
        }

        void swap(Function<T, T> applier) {
            T next;
            T current;
            while (!this.reference.compareAndSet(current = this.reference.get(), next = applier.apply(current))) {
            }
        }

        T deref() {
            return this.reference.get();
        }
    }
}

