/*
 * Decompiled with CFR 0.152.
 */
package momentum.core;

import java.nio.ByteBuffer;
import java.util.HashMap;
import momentum.core.Buffer;
import org.jboss.netty.buffer.ChannelBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BufferBackedBuffer
extends Buffer {
    final int offset;
    final Buffer buf;

    protected BufferBackedBuffer(Buffer buf, int offset, int pos, int lim, int cap) {
        this(buf, offset, pos, lim, cap, true);
    }

    protected BufferBackedBuffer(Buffer buf, int offset, int pos, int lim, int cap, boolean be) {
        super(pos, lim, cap, be);
        this.offset = offset;
        this.buf = buf;
    }

    @Override
    protected Buffer _slice(int idx, int len) {
        return new BufferBackedBuffer(this.buf, this.offset + idx, 0, len, len, this.bigEndian);
    }

    @Override
    protected HashMap<String, String> toStringAttrs() {
        HashMap<String, String> ret = super.toStringAttrs();
        ret.put("offset", Integer.toString(this.offset));
        ret.put("buffer", this.buf.toString());
        return ret;
    }

    @Override
    protected ByteBuffer _toByteBuffer() {
        ByteBuffer ret = this.buf._toByteBuffer();
        if (this.offset > 0 || this.capacity < ret.capacity()) {
            ret.position(this.offset);
            ret.limit(this.offset + this.capacity);
            ret = ret.slice();
        }
        return ret;
    }

    @Override
    protected ChannelBuffer _toChannelBuffer() {
        ChannelBuffer ret = this.buf._toChannelBuffer();
        if (this.offset > 0 || this.capacity < ret.capacity()) {
            ret = ret.slice(this.offset, this.capacity);
        }
        return ret;
    }

    @Override
    protected byte[] _toByteArray() {
        if (this.offset == 0 && this.capacity == this.buf.capacity) {
            return this.buf._toByteArray();
        }
        byte[] ret = new byte[this.capacity];
        this._get(0, ret, 0, this.capacity);
        return ret;
    }

    @Override
    protected byte _get(int idx) {
        return this.buf._get(this.offset + idx);
    }

    @Override
    protected void _get(int idx, byte[] dst, int off, int len) {
        this.buf._get(this.offset + idx, dst, off, len);
    }

    @Override
    protected void _put(int idx, byte b) {
        this.buf._put(this.offset + idx, b);
    }

    @Override
    protected void _put(int idx, byte[] src, int off, int len) {
        this.buf._put(this.offset + idx, src, off, len);
    }
}

