/*
 * Decompiled with CFR 0.152.
 */
package momentum.core;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import momentum.core.Buffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ByteBufferBackedBuffer
extends Buffer {
    final ByteBuffer buf;

    protected ByteBufferBackedBuffer(ByteBuffer buf) {
        this(buf, buf.position(), buf.limit(), buf.capacity());
    }

    protected ByteBufferBackedBuffer(ByteBuffer buf, int pos, int lim, int cap) {
        this(buf, pos, lim, cap, true);
    }

    protected ByteBufferBackedBuffer(ByteBuffer buf, int pos, int lim, int cap, boolean be) {
        super(pos, lim, cap, be);
        this.buf = buf;
    }

    @Override
    protected Buffer _slice(int idx, int len) {
        this.buf.position(idx);
        this.buf.limit(idx + len);
        ByteBuffer newBuf = this.buf.slice();
        this.buf.limit(this.capacity);
        return new ByteBufferBackedBuffer(newBuf, 0, len, len, this.bigEndian);
    }

    @Override
    protected HashMap<String, String> toStringAttrs() {
        HashMap<String, String> ret = super.toStringAttrs();
        ret.put("buffer", this.buf.toString());
        return ret;
    }

    @Override
    protected ByteBuffer _toByteBuffer() {
        return this.buf.duplicate();
    }

    @Override
    protected ChannelBuffer _toChannelBuffer() {
        ByteBuffer b = this.buf.duplicate();
        b.position(0);
        b.limit(this.capacity);
        b.order(this.order());
        return ChannelBuffers.wrappedBuffer((ByteBuffer)b);
    }

    @Override
    protected byte[] _toByteArray() {
        if (this.buf.hasArray() && this.buf.arrayOffset() == 0) {
            byte[] ret = this.buf.array();
            if (ret.length == this.capacity) {
                return ret;
            }
            return Arrays.copyOf(ret, this.capacity);
        }
        return super._toByteArray();
    }

    @Override
    protected byte _get(int idx) {
        return this.buf.get(idx);
    }

    @Override
    protected void _get(int idx, byte[] dst, int off, int len) {
        this.buf.position(idx);
        this.buf.get(dst, off, len);
    }

    @Override
    protected void _put(int idx, byte b) {
        this.buf.put(idx, b);
    }

    @Override
    protected void _put(int idx, byte[] src, int off, int len) {
        this.buf.position(idx);
        this.buf.put(src, off, len);
    }
}

