/*
 * Decompiled with CFR 0.152.
 */
package momentum.core;

import clojure.lang.AFn;
import clojure.lang.IPending;
import clojure.lang.ISeq;
import clojure.lang.Seqable;
import momentum.core.Deferred;
import momentum.core.DeferredSeq;
import momentum.core.Receivable;

public final class Channel
extends AFn
implements Seqable,
IPending {
    static final Deferred channelClosed = Deferred.aborted(new RuntimeException("Channel closed"));
    final boolean canBlock;
    final long timeout;
    volatile DeferredSeq head;
    DeferredSeq tail;

    public Channel() {
        this(false, 0L);
    }

    public Channel(long ms) {
        this(true, ms);
    }

    Channel(boolean blk, long ms) {
        this.canBlock = blk;
        this.timeout = ms;
        this.head = this.tail = new DeferredSeq(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Receivable put(Object v) {
        DeferredSeq curr;
        Channel channel = this;
        synchronized (channel) {
            curr = this.tail;
            if (curr == null) {
                return channelClosed;
            }
            this.tail = curr.grow();
        }
        return curr.put(v);
    }

    public Object invoke(Object v) {
        return this.put(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Receivable putLast(Object v) {
        DeferredSeq curr;
        Channel channel = this;
        synchronized (channel) {
            curr = this.tail;
            if (curr == null) {
                return channelClosed;
            }
            this.tail = null;
        }
        return curr.put(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(Exception err) {
        DeferredSeq curr;
        Channel channel = this;
        synchronized (channel) {
            curr = this.tail;
            if (curr == null) {
                return;
            }
            this.tail = null;
        }
        curr.abort(err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DeferredSeq curr;
        Channel channel = this;
        synchronized (channel) {
            curr = this.tail;
            this.tail = null;
        }
        if (curr != null && !curr.isRealized()) {
            curr.put(null);
        }
    }

    public ISeq seq() {
        return this.head;
    }

    public boolean isRealized() {
        DeferredSeq curr = this.head;
        return curr == null || curr.isRealized();
    }
}

