/*
 * Decompiled with CFR 0.152.
 */
package momentum.core;

import clojure.lang.AFn;
import clojure.lang.IBlockingDeref;
import clojure.lang.IDeref;
import clojure.lang.IPending;
import java.util.LinkedList;
import momentum.core.Receivable;
import momentum.core.Receiver;

public final class Deferred
extends AFn
implements Receivable,
IDeref,
IBlockingDeref,
IPending {
    volatile boolean isRealized;
    boolean isBlocked;
    Object value;
    Exception err;
    final LinkedList<Receiver> receivers = new LinkedList();

    public static Deferred aborted(Exception e) {
        Deferred ret = new Deferred();
        ret.abort(e);
        return ret;
    }

    public static Deferred realized(Object v) {
        Deferred ret = new Deferred();
        ret.put(v);
        return ret;
    }

    public boolean isRealized() {
        return this.isRealized;
    }

    public boolean isSuccessful() {
        return this.isRealized && this.err == null;
    }

    public boolean isAborted() {
        return this.isRealized && this.err != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(Object v) {
        Receiver r;
        Deferred deferred = this;
        synchronized (deferred) {
            if (this.isRealized) {
                return false;
            }
            this.value = v;
            this.isRealized = true;
            if (this.isBlocked) {
                this.notifyAll();
            }
        }
        while ((r = this.receivers.poll()) != null) {
            this.deliver(r);
        }
        return true;
    }

    public Object invoke(Object v) {
        return this.put(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean abort(Exception e) {
        Receiver r;
        Deferred deferred = this;
        synchronized (deferred) {
            if (this.isRealized) {
                return false;
            }
            this.err = e;
            this.isRealized = true;
            if (this.isBlocked) {
                this.notifyAll();
            }
        }
        while ((r = this.receivers.poll()) != null) {
            this.deliver(r);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Receiver r) {
        if (r == null) {
            throw new NullPointerException("Receiver is null");
        }
        if (this.isRealized) {
            this.deliver(r);
            return;
        }
        Deferred deferred = this;
        synchronized (deferred) {
            if (!this.isRealized) {
                this.receivers.add(r);
                return;
            }
        }
        this.deliver(r);
    }

    public Object deref() {
        return this.deref(-1L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deref(long ms, Object timeoutValue) {
        if (!this.isRealized) {
            if (ms == 0L) {
                return timeoutValue;
            }
            Deferred deferred = this;
            synchronized (deferred) {
                this.isBlocked = true;
                try {
                    if (ms < 0L) {
                        this.wait();
                    } else {
                        this.wait(ms);
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (!this.isRealized) {
                    return timeoutValue;
                }
            }
        }
        if (this.err != null) {
            throw new RuntimeException(this.err);
        }
        return this.value;
    }

    private void deliver(Receiver receiver) {
        try {
            if (this.err != null) {
                receiver.error(this.err);
            } else {
                receiver.success(this.value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

