/*
 * Decompiled with CFR 0.152.
 */
package momentum.http;

import momentum.core.Buffer;
import momentum.http.HttpParser;
import momentum.http.HttpParserException;
import momentum.http.Mark;

public class ChunkedValue {
    private int bridgeCount;
    protected Mark complete;
    protected Mark current;
    protected Mark tenative;

    public ChunkedValue(Buffer buf, int offset) {
        this.current = new Mark(buf, offset);
        this.current.mark(buf.limit());
    }

    public void mark(int offset) {
        if (this.tenative != null) {
            this.tenative.mark(offset);
            this.current = this.tenative;
            this.tenative = null;
        } else if (this.current != null) {
            this.current.mark(offset);
        } else {
            throw new HttpParserException("Cannot mark at this time");
        }
    }

    public void concat(Buffer buf) {
        this.start(buf, 0);
        this.mark(buf.limit());
        this.push();
    }

    public void start(Buffer buf, int offset) {
        if (this.current != null || this.tenative != null) {
            throw new HttpParserException("Cannot start a new segment at this time");
        }
        this.current = new Mark(buf, offset, this.complete);
        this.current.mark(buf.limit());
    }

    public void push() {
        if (this.current != null) {
            this.current.finalize();
            this.complete = this.current;
            this.current = null;
            this.tenative = null;
        }
    }

    public void push(int offset) {
        this.mark(offset);
        this.push();
    }

    public byte[] materialize() {
        byte[] materialized = this.complete.materialize();
        if (materialized == null) {
            return HttpParser.EMPTY_BUFFER;
        }
        return materialized;
    }

    public String materializeStr() {
        byte[] materialized = this.complete.materialize();
        if (materialized == null) {
            return HttpParser.EMPTY_STRING;
        }
        return new String(materialized);
    }

    public void bridge(Buffer buf) {
        if (++this.bridgeCount > 10) {
            String msg = "Value broken into too many chunks";
            throw new HttpParserException(msg);
        }
        if (this.current == null) {
            return;
        }
        if (this.tenative != null) {
            this.tenative = this.tenative.bridge(buf);
            return;
        }
        Mark remaining = this.current.remaining();
        this.tenative = remaining == null ? new Mark(buf, 0, this.current) : new Mark(buf, 0, remaining);
    }
}

