/*
 * Decompiled with CFR 0.152.
 */
package momentum.http;

import momentum.buffer.Buffer;
import momentum.http.ChunkedValue;
import momentum.http.HeaderValue;
import momentum.http.HttpParser;
import momentum.http.HttpParserException;
import momentum.http.MultipartParserCallback;

public final class MultipartParser {
    static final byte CR = 13;
    static final byte LF = 10;
    static final byte DASH = 45;
    static final byte[] PREFIX = new byte[]{13, 10, 45, 45};
    private int cs = 1;
    private int delimiterPos;
    private boolean parsingBody;
    private Object headers;
    private String headerName;
    private ChunkedValue headerNameChunks;
    private HeaderValue headerValue;
    private final Buffer delimiter;
    private final MultipartParserCallback callback;
    private static final byte[] _multipart_actions = MultipartParser.init__multipart_actions_0();
    private static final byte[] _multipart_key_offsets = MultipartParser.init__multipart_key_offsets_0();
    private static final char[] _multipart_trans_keys = MultipartParser.init__multipart_trans_keys_0();
    private static final byte[] _multipart_single_lengths = MultipartParser.init__multipart_single_lengths_0();
    private static final byte[] _multipart_range_lengths = MultipartParser.init__multipart_range_lengths_0();
    private static final byte[] _multipart_index_offsets = MultipartParser.init__multipart_index_offsets_0();
    private static final byte[] _multipart_indicies = MultipartParser.init__multipart_indicies_0();
    private static final byte[] _multipart_trans_targs = MultipartParser.init__multipart_trans_targs_0();
    private static final byte[] _multipart_trans_actions = MultipartParser.init__multipart_trans_actions_0();
    private static final byte[] _multipart_eof_actions = MultipartParser.init__multipart_eof_actions_0();
    static final int multipart_start = 1;
    static final int multipart_first_final = 18;
    static final int multipart_error = 0;
    static final int multipart_en_main = 1;
    static final int multipart_en_main_multipart_start = 1;
    static final int multipart_en_main_multipart_delimiter = 2;
    static final int multipart_en_main_multipart_head = 3;
    static final int multipart_en_main_multipart_body = 1;
    static final int multipart_en_main_multipart_epilogue = 17;

    private static byte[] init__multipart_actions_0() {
        return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 4, 1, 5, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 2, 2, 6, 2, 3, 0, 2, 9, 10, 2, 11, 6, 3, 8, 9, 10};
    }

    private static byte[] init__multipart_key_offsets_0() {
        return new byte[]{0, 0, 0, 0, 4, 7, 8, 23, 24, 24, 41, 44, 50, 51, 68, 74, 80, 81};
    }

    private static char[] init__multipart_trans_keys_0() {
        return new char[]{'\t', '\r', ' ', '-', '\t', '\r', ' ', '\n', '\r', '\"', ',', '/', '{', '}', '\u007f', '\u0000', ' ', '(', ')', ':', '@', '[', ']', '\n', '\t', ' ', '\"', ',', '/', ':', '{', '}', '\u007f', '\u0000', '\u001f', '(', ')', ';', '@', '[', ']', '\t', ' ', ':', '\t', '\r', ' ', '\u007f', '\u0000', '\u001f', '\n', '\t', '\r', ' ', '\"', ',', '/', '{', '}', '\u007f', '\u0000', '\u001f', '(', ')', ':', '@', '[', ']', '\t', '\r', ' ', '\u007f', '\u0000', '\u001f', '\t', '\r', ' ', '\u007f', '\u0000', '\u001f', '-', '\u0000'};
    }

    private static byte[] init__multipart_single_lengths_0() {
        return new byte[]{0, 0, 0, 4, 3, 1, 7, 1, 0, 9, 3, 4, 1, 9, 4, 4, 1, 0};
    }

    private static byte[] init__multipart_range_lengths_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 4, 0, 0, 4, 0, 1, 0, 4, 1, 1, 0, 0};
    }

    private static byte[] init__multipart_index_offsets_0() {
        return new byte[]{0, 0, 1, 2, 7, 11, 13, 25, 27, 28, 42, 46, 52, 54, 68, 74, 80, 82};
    }

    private static byte[] init__multipart_indicies_0() {
        return new byte[]{0, 1, 3, 4, 3, 5, 2, 3, 4, 3, 2, 6, 2, 7, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 9, 2, 10, 11, 11, 2, 2, 2, 13, 2, 2, 2, 2, 2, 2, 2, 12, 14, 14, 15, 2, 15, 16, 15, 2, 2, 17, 18, 2, 15, 19, 15, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 20, 21, 22, 21, 2, 2, 23, 24, 25, 24, 2, 2, 23, 26, 2, 27, 0};
    }

    private static byte[] init__multipart_trans_targs_0() {
        return new byte[]{1, 2, 0, 4, 5, 16, 6, 7, 9, 8, 1, 10, 9, 11, 10, 11, 12, 14, 13, 7, 9, 15, 12, 14, 15, 12, 4, 17};
    }

    private static byte[] init__multipart_trans_actions_0() {
        return new byte[]{1, 3, 9, 0, 0, 0, 0, 5, 21, 0, 24, 11, 0, 11, 0, 0, 33, 13, 0, 19, 30, 15, 27, 0, 0, 17, 7, 0};
    }

    private static byte[] init__multipart_eof_actions_0() {
        return new byte[]{0, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
    }

    public MultipartParser(Buffer boundary, MultipartParserCallback callback) {
        Buffer delimiter = Buffer.allocate(4 + boundary.remaining());
        delimiter.put(PREFIX);
        delimiter.put(boundary);
        delimiter.flip();
        this.delimiter = delimiter;
        this.callback = callback;
    }

    /*
     * Unable to fully structure code
     */
    public void execute(Buffer buf) {
        bodyStart = 0;
        bodyEnd = 0;
        p = buf.position();
        pe = buf.limit();
        eof = pe + 1;
        this.bridge(buf, this.headerNameChunks);
        this.bridge(buf, this.headerValue);
        _trans = 0;
        _goto_targ = 0;
        block23: while (true) {
            switch (_goto_targ) {
                case 0: {
                    if (p == pe) {
                        _goto_targ = 4;
                        continue block23;
                    }
                    if (this.cs == 0) {
                        _goto_targ = 5;
                        continue block23;
                    }
                }
                case 1: {
                    _keys = MultipartParser._multipart_key_offsets[this.cs];
                    _trans = MultipartParser._multipart_index_offsets[this.cs];
                    _klen = MultipartParser._multipart_single_lengths[this.cs];
                    if (_klen <= 0) ** GOTO lbl38
                    _lower = _keys;
                    _upper = _keys + _klen - 1;
                    while (_upper >= _lower) {
                        _mid = _lower + (_upper - _lower >> 1);
                        if (buf.get(p) < MultipartParser._multipart_trans_keys[_mid]) {
                            _upper = _mid - 1;
                            continue;
                        }
                        if (buf.get(p) > MultipartParser._multipart_trans_keys[_mid]) {
                            _lower = _mid + 1;
                            continue;
                        }
                        _trans += _mid - _keys;
                        ** GOTO lbl52
                    }
                    _keys += _klen;
                    _trans += _klen;
lbl38:
                    // 2 sources

                    if ((_klen = MultipartParser._multipart_range_lengths[this.cs]) > 0) {
                        _lower = _keys;
                        _upper = _keys + (_klen << 1) - 2;
                        while (_upper >= _lower) {
                            _mid = _lower + (_upper - _lower >> 1 & -2);
                            if (buf.get(p) < MultipartParser._multipart_trans_keys[_mid]) {
                                _upper = _mid - 2;
                                continue;
                            }
                            if (buf.get(p) > MultipartParser._multipart_trans_keys[_mid + 1]) {
                                _lower = _mid + 2;
                                continue;
                            }
                            _trans += _mid - _keys >> 1;
                            ** GOTO lbl52
                        }
                        _trans += _klen;
                    }
lbl52:
                    // 5 sources

                    _trans = MultipartParser._multipart_indicies[_trans];
                    this.cs = MultipartParser._multipart_trans_targs[_trans];
                    if (MultipartParser._multipart_trans_actions[_trans] != 0) {
                        _acts = MultipartParser._multipart_trans_actions[_trans];
                        _nacts = MultipartParser._multipart_actions[_acts++];
                        while (_nacts-- > 0) {
                            block6 : switch (MultipartParser._multipart_actions[_acts++]) {
                                case 0: {
                                    if (13 == buf.get(p)) {
                                        bodyEnd = p;
                                        curr = 0;
                                        limit = Math.min(this.delimiter.limit(), buf.limit() - p);
                                        while (++curr < limit) {
                                            if (this.delimiter.get(curr) == buf.get(p + curr)) continue;
                                            p = p + curr - 1;
                                            break block6;
                                        }
                                        if (curr == this.delimiter.limit()) {
                                            if (this.parsingBody) {
                                                if (this.headers != null) {
                                                    this.callback.part(this.headers, this.slice(buf, bodyStart, bodyEnd));
                                                    this.headers = null;
                                                } else {
                                                    if (bodyEnd > bodyStart) {
                                                        this.callback.chunk(this.slice(buf, bodyStart, bodyEnd));
                                                    }
                                                    this.callback.chunk(null);
                                                }
                                                bodyStart = 0;
                                                bodyEnd = 0;
                                            }
                                            this.cs = 3;
                                            p = p + curr - 1;
                                            break;
                                        }
                                        if (this.parsingBody) {
                                            if (this.headers != null) {
                                                this.callback.part(this.headers, null);
                                                this.headers = null;
                                            }
                                            if (bodyEnd > bodyStart) {
                                                this.callback.chunk(this.slice(buf, bodyStart, bodyEnd));
                                            }
                                            bodyStart = 0;
                                            bodyEnd = 0;
                                        }
                                        this.delimiterPos = curr;
                                        this.cs = 2;
                                        return;
                                    }
                                    bodyEnd = p + 1;
                                    break;
                                }
                                case 1: {
                                    limit = Math.min(this.delimiter.limit() - this.delimiterPos, buf.limit());
                                    for (curr = 0; curr < limit; ++curr) {
                                        if (this.delimiter.get(curr + this.delimiterPos) == buf.get(curr)) continue;
                                        if (this.parsingBody) {
                                            this.callback.chunk(this.slice(this.delimiter, 0, this.delimiterPos + curr));
                                            bodyStart = p + curr;
                                            p = p + curr - 1;
                                            this.cs = 1;
                                            break block6;
                                        }
                                        p = p + curr - 1;
                                        this.cs = 1;
                                        break block6;
                                    }
                                    if (curr == this.delimiter.limit() - this.delimiterPos) {
                                        if (this.parsingBody) {
                                            this.callback.chunk(null);
                                        }
                                        this.cs = 3;
                                        p = p + curr - 1;
                                        break;
                                    }
                                    this.delimiterPos += curr;
                                    return;
                                }
                                case 2: {
                                    this.parsingBody = true;
                                    this.headers = this.callback.blankHeaders();
                                    bodyStart = 0;
                                    bodyEnd = 0;
                                    break;
                                }
                                case 3: {
                                    bodyStart = p;
                                    break;
                                }
                                case 4: {
                                    this.callback.done();
                                    this.cs = 17;
                                    _goto_targ = 2;
                                    continue block23;
                                }
                                case 5: {
                                    throw new HttpParserException("Something went wrong: " + p);
                                }
                                case 6: {
                                    this.headerNameChunks = new ChunkedValue(buf, p);
                                    break;
                                }
                                case 7: {
                                    if (this.headerNameChunks == null) break;
                                    this.headerNameChunks.push(p);
                                    this.headerName = this.headerNameChunks.materializeStr().toLowerCase();
                                    this.headerNameChunks = null;
                                    break;
                                }
                                case 8: {
                                    if (this.headerValue == null) {
                                        this.headerValue = new HeaderValue(buf, p);
                                        break;
                                    }
                                    this.headerValue.startLine(buf, p);
                                    break;
                                }
                                case 9: {
                                    if (this.headerValue == null) break;
                                    this.headerValue.mark(p);
                                    break;
                                }
                                case 10: {
                                    if (this.headerValue == null) break;
                                    this.headerValue.push();
                                    break;
                                }
                                case 11: {
                                    if (this.headerValue != null) {
                                        this.callback.header(this.headers, this.headerName, this.headerValue.materializeStr());
                                        this.headerName = null;
                                        this.headerValue = null;
                                        break;
                                    }
                                    if (this.headerName == null) break;
                                    this.callback.header(this.headers, this.headerName, HttpParser.EMPTY_STRING);
                                    this.headerName = null;
                                }
                            }
                        }
                    }
                }
                case 2: {
                    if (this.cs == 0) {
                        _goto_targ = 5;
                        continue block23;
                    }
                    if (++p != pe) {
                        _goto_targ = 1;
                        continue block23;
                    }
                }
                case 4: {
                    if (p != eof) break block23;
                    __acts = MultipartParser._multipart_eof_actions[this.cs];
                    __nacts = MultipartParser._multipart_actions[__acts++];
                    while (__nacts-- > 0) {
                        switch (MultipartParser._multipart_actions[__acts++]) {
                            case 5: {
                                throw new HttpParserException("Something went wrong: " + p);
                            }
                        }
                    }
                    break block23;
                }
            }
            break;
        }
        if (this.parsingBody && bodyEnd > bodyStart) {
            if (this.headers != null) {
                this.callback.part(this.headers, null);
                this.headers = null;
            }
            this.callback.chunk(this.slice(buf, bodyStart, buf.limit()));
        }
    }

    private void bridge(Buffer buf, ChunkedValue chunk) {
        if (chunk != null) {
            chunk.bridge(buf);
        }
    }

    private Buffer slice(Buffer buf, int from, int to) {
        Buffer chunk = buf.duplicate();
        chunk.position(from);
        chunk.limit(to);
        return chunk;
    }
}

