/*
 * Decompiled with CFR 0.152.
 */
package momentum.async;

import clojure.lang.Cons;
import clojure.lang.IFn;
import clojure.lang.IPersistentCollection;
import clojure.lang.ISeq;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.SeqIterator;
import clojure.lang.Sequential;
import clojure.lang.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import momentum.async.Async;
import momentum.async.Receiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsyncSeq
extends Async<ISeq>
implements ISeq,
Sequential,
List,
Receiver {
    IFn fn;

    public AsyncSeq(IFn fn) {
        this.fn = fn;
    }

    public AsyncSeq(Async a) {
        a.receive(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean observe() {
        Object ret;
        IFn fn;
        if (this.isRealized) {
            return true;
        }
        AsyncSeq asyncSeq = this;
        synchronized (asyncSeq) {
            if (this.fn == null) {
                return this.isRealized;
            }
            fn = this.fn;
            this.fn = null;
        }
        try {
            ret = fn.invoke();
        }
        catch (Exception e) {
            this.realizeError(e);
            return true;
        }
        if (ret instanceof Async) {
            ((Async)((Object)ret)).receive(this);
            return this.isRealized;
        }
        this.success(ret);
        return true;
    }

    @Override
    public void success(Object val) {
        try {
            ISeq s = RT.seq((Object)val);
            this.realizeSuccess(s);
        }
        catch (Exception e) {
            this.realizeError(e);
        }
    }

    @Override
    public void error(Exception e) {
        this.realizeError(e);
    }

    void ensureSuccess() {
        if (this.observe()) {
            if (this.err != null) {
                throw Util.runtimeException((Throwable)this.err);
            }
            return;
        }
        throw new RuntimeException("Async seq has not been realized yet");
    }

    public ISeq seq() {
        if (this.isRealized()) {
            if (this.err != null) {
                throw Util.runtimeException((Throwable)this.err);
            }
            return RT.seq((Object)this.val);
        }
        return this;
    }

    public Object first() {
        this.ensureSuccess();
        if (this.val == null) {
            return null;
        }
        return ((ISeq)this.val).first();
    }

    public ISeq next() {
        this.ensureSuccess();
        if (this.val == null) {
            return null;
        }
        return ((ISeq)this.val).next();
    }

    public ISeq more() {
        this.ensureSuccess();
        if (this.val == null) {
            return PersistentList.EMPTY;
        }
        return ((ISeq)this.val).more();
    }

    public ISeq cons(Object o) {
        return new Cons(o, this.seq());
    }

    public int count() {
        int c = 0;
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            ++c;
        }
        return c;
    }

    public IPersistentCollection empty() {
        return PersistentList.EMPTY;
    }

    public boolean equiv(Object o) {
        return this.equals(o);
    }

    @Override
    public boolean equals(Object o) {
        this.ensureSuccess();
        if (this.val != null) {
            return ((ISeq)this.val).equiv(o);
        }
        return (o instanceof Sequential || o instanceof List) && RT.seq((Object)o) == null;
    }

    @Override
    public Object[] toArray() {
        return RT.seqToArray((ISeq)this.seq());
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length >= this.count()) {
            int i = 0;
            for (ISeq s = this.seq(); s != null; s = s.next()) {
                a[i] = s.first();
                ++i;
            }
            if (a.length > this.count()) {
                a[this.count()] = null;
            }
            return a;
        }
        return this.toArray();
    }

    @Override
    public int size() {
        return this.count();
    }

    @Override
    public boolean isEmpty() {
        return this.seq() == null;
    }

    @Override
    public boolean contains(Object o) {
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            if (!Util.equiv((Object)s.first(), (Object)o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        return new SeqIterator(this.seq());
    }

    List reify() {
        return new ArrayList(this);
    }

    public List subList(int fromIndex, int toIndex) {
        return this.reify().subList(fromIndex, toIndex);
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        ISeq s = this.seq();
        int i = 0;
        while (s != null) {
            if (Util.equiv((Object)s.first(), (Object)o)) {
                return i;
            }
            s = s.next();
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.reify().lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.reify().listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.reify().listIterator(index);
    }

    public Object get(int index) {
        return RT.nth((Object)this, (int)index);
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException();
    }
}

