/*
 * Decompiled with CFR 0.152.
 */
package momentum.http;

import momentum.buffer.Buffer;

public class Mark {
    protected final Mark previous;
    protected final Buffer buf;
    protected final int from;
    protected int to;
    protected int total;

    public Mark(Buffer buf, int from) {
        this(buf, from, null);
    }

    public Mark(Buffer buf, int from, Mark previous) {
        this.buf = buf;
        this.from = from;
        this.to = from;
        this.previous = previous;
    }

    public Mark previous() {
        return this.previous;
    }

    public void mark(int offset) {
        this.to = offset;
    }

    public String toString() {
        String str = this.buf.toString();
        return "Mark('" + str + "', " + this.from + ", " + this.to + ")";
    }

    public void finalize() {
        this.total = this.to - this.from;
        if (this.previous != null) {
            this.total += this.previous.total();
        }
    }

    public void finalize(int offset) {
        this.mark(offset);
        this.finalize();
    }

    public Mark bridge(Buffer nextBuf) {
        this.finalize(this.buf.limit());
        return new Mark(nextBuf, 0, this);
    }

    public Mark remaining() {
        this.finalize();
        if (this.to == this.buf.limit()) {
            return null;
        }
        Mark rest = new Mark(this.buf, this.to, this);
        rest.finalize(this.buf.limit());
        return rest;
    }

    public byte[] materialize() {
        if (this.total() == 0) {
            return null;
        }
        byte[] buf = new byte[this.total()];
        int pos = 0;
        for (Mark cur = this; cur != null; cur = cur.previous()) {
            pos += cur.copy(buf, pos);
        }
        return buf;
    }

    protected int total() {
        return this.total;
    }

    protected int copy(byte[] dst, int pos) {
        int oldPos = this.buf.position();
        int oldLim = this.buf.limit();
        int length = this.to - this.from;
        this.buf.position(this.from);
        this.buf.limit(this.to);
        this.buf.get(dst, dst.length - (pos + length), length);
        this.buf.position(oldPos);
        this.buf.limit(oldLim);
        return length;
    }
}

