(ns lib.sentry.exceptions)

(defn- make-frame
  [^StackTraceElement element app-namespaces]
  {:filename (.getFileName element)
   :lineno   (.getLineNumber element)
   :function (str (.getClassName element) "." (.getMethodName element))
   :in_app   (boolean (some #(.startsWith (.getClassName element) %) app-namespaces))})

(defn- make-stacktrace-info
  [elements app-namespaces]
  {:frames (reverse (map #(make-frame % app-namespaces) elements))})

(defn stacktrace
  [event-map ^Exception e & [app-namespaces]]
  (assoc event-map
         :exception [{:stacktrace (make-stacktrace-info (.getStackTrace e) app-namespaces)
                      :type       (str (class e))
                      :value      (.getMessage e)}]))

(defn message
  [event-map ^Exception ex]
  (if (:message event-map)
    ;; already a message?
    event-map
    (assoc event-map :message (.getMessage ex))))

(defn tags
  [event-map ^Exception ex]
  (if-let [tags (:tags (ex-data ex))]
    (assoc event-map :tags tags)
    event-map))

(defn extra
  [event-map ^Exception ex]
  (if-let [data (ex-data ex)]
    (update-in event-map [:extra] merge data)
    event-map))
