(try (load-file "common.clj")
     (catch java.io.FileNotFoundException _
       (load-file "../../common.clj")))

(def otel-version "0.2.7")

(defproject io.trosa/component.telemetry components-version
  :plugins [[lein-monolith "1.9.0"]]
  :monolith/inherit true
  :deployable true
  :dependencies [[io.trosa/commons]
                 [com.github.steffan-westcott/clj-otel-api                         ~otel-version]
                 [com.github.steffan-westcott/clj-otel-sdk                         ~otel-version]
                 [com.github.steffan-westcott/clj-otel-sdk-extension-autoconfigure ~otel-version]
                 [com.github.steffan-westcott/clj-otel-instrumentation-resources   ~otel-version]
                 [com.github.steffan-westcott/clj-otel-extension-trace-propagators ~otel-version]
                 [com.github.steffan-westcott/clj-otel-exporter-otlp               ~otel-version]]
  :profiles {:dev {:dependencies [[integrant/repl]
                                  [org.clojure/tools.namespace]]
                   :source-paths ["dev"]}
             :uberjar {:aot :all}})
