;;  __      __      ___.     _________
;; /  \    /  \ ____\_ |__  /   _____/ ______________  __ ___________
;; \   \/\/   // __ \| __ \ \_____  \_/ __ \_  __ \  \/ // __ \_  __ \
;;  \        /\  ___/| \_\ \/        \  ___/|  | \/\   /\  ___/|  | \/
;;   \__/\  /  \___  >___  /_______  /\___  >__|    \_/  \___  >__|
;;        \/       \/    \/        \/     \/                 \/

(try (load-file "common.clj")
     (catch java.io.FileNotFoundException _
       (load-file "../../common.clj")))

(def reitit-version   "0.8.0")
(def pedestal-version "0.6.2")
(def logback-version  "1.4.13")

(defproject io.trosa/component.webserver components-version
  :plugins [[lein-monolith "1.9.0"]]
  :monolith/inherit true
  :deployable true
  :dependencies [[integrant]
                 [io.trosa/commons]
                 [metosin/reitit                  ~reitit-version]
                 [metosin/reitit-pedestal         ~reitit-version]
                 [io.pedestal/pedestal.jetty      ~pedestal-version]
                 [io.pedestal/pedestal.service    ~pedestal-version]]
  :profiles {:dev {:dependencies [[integrant/repl]
                                  [org.clojure/tools.namespace]
                                  [io.pedestal/pedestal.service-tools ~pedestal-version]
                                  [spootnik/unilog]
                                  [clj-http "3.13.0"]]
                   :source-paths ["dev"]}
             :uberjar {:aot :all}})
