;; ____  ______________________ __________
;; \   \/  /\__    ___/\______ \\______   \
;;  \     /   |    |    |    |  \|    |  _/
;;  /     \   |    |    |    `   \    |   \
;; /___/\  \  |____|   /_______  /______  /
;;       \_/                   \/       \/

(try (load-file "common.clj")
     (catch java.io.FileNotFoundException _
       (load-file "../../common.clj")))

(def xtdb-version "1.24.0")

(defproject io.trosa/component.xtdb components-version
  :plugins [[lein-monolith "1.9.0"]]
  :monolith/inherit true
  :deployable true
  :dependencies [[integrant]
                 [commons]
                 [org.clojure/tools.logging]
                 [com.xtdb/xtdb-core      ~xtdb-version]
                 [com.xtdb/xtdb-metrics   ~xtdb-version]
                 [com.xtdb/xtdb-rocksdb   ~xtdb-version]]
  :profiles {:dev {:dependencies [[integrant/repl]
                                  [org.clojure/tools.namespace]]
                   :source-paths ["dev"]}
             :uberjar {:aot :all}})
