(ns component.xtdb
  (:require [integrant.core :as ig]
            [commons.system :refer [assert-system!]]
            [commons.runtime :refer [runtime-properties]]
            [clojure.tools.logging :as log]
            [xtdb.api :as xt]
            [xtdb.rocksdb]))

;; ____  ______________________ __________
;; \   \/  /\__    ___/\______ \\______   \
;;  \     /   |    |    |    |  \|    |  _/
;;  /     \   |    |    |    `   \    |   \
;; /___/\  \  |____|   /_______  /______  /
;;       \_/                   \/       \/

(def default-configuration
  {:component/xtdb {:logging (ig/ref :component/logging)}})

(defn- ping-fn
  [node]
  (assoc (.status node)
         :ok true
         :latest-completed-tx (xt/latest-completed-tx node)
         :latest-submitted-tx (xt/latest-submitted-tx node)))

(defmethod ig/init-key :component/xtdb
  [_ system]
  (let [node (xt/start-node (dissoc system :logging))]
    (log/info "starting XTDB component")
    (assert-system!
     (assoc system
            :node node
            :ping-fn (partial ping-fn node)
            :props-fn runtime-properties))))

(defmethod ig/halt-key! :component/xtdb
  [_ {:keys [node]}]
  (log/info "stopping XTDB component")
  (when node
    (.close node)))
