(ns geospatial.geojson
  (:require [geospatial.geojson.specs :as spec]))

(defn get-coords
  "Yields all coordinate tuples from a geometry
   or feature object."
  {:added "0.1.0"}
  [geojson]
  (->> (spec/validate-geojson geojson)
       (:coordinates)))

(defn transpose-coords
  "Maps a function over all coordinate values and returns a geometry
  of the same type.

  Can be useful for scaling a geometry."
  {:added "0.1.0"}
  [geojson transpose-fn]
  (-> (spec/validate-geojson geojson)
      (update :coordinates
              (fn [coords]
                (mapv (fn [coord]
                        (mapv (fn [x]
                                (transpose-fn x)) coord))
                      coords)))))
