/*
 * Decompiled with CFR 0.152.
 */
package io.xapix.capbac;

import io.xapix.capbac.CapBAC;
import io.xapix.capbac.CapBACCertificate;
import io.xapix.capbac.CapBACInvocation;
import io.xapix.capbac.CapBACPubs;
import io.xapix.capbac.CapBACTrustChecker;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;

public class CapBACValidator {
    private final CapBACTrustChecker trustChecker;
    private final CapBACPubs pubs;

    public CapBACValidator(CapBACTrustChecker trustChecker, CapBACPubs pubs) {
        this.trustChecker = trustChecker;
        this.pubs = pubs;
    }

    public void validate(CapBACCertificate cert, long now) throws CapBAC.Expired, CapBAC.Invalid, CapBAC.BadSign, CapBAC.BadID {
        for (CapBACCertificate certInChain : cert) {
            ECPublicKey issuerKey;
            if (certInChain.getExp() != 0L && certInChain.getExp() < now) {
                throw new CapBAC.Expired();
            }
            if (certInChain.getParent() == null) {
                if (!this.trustChecker.check(certInChain.getRoot().getIssuer())) {
                    throw new CapBAC.Invalid("Untrusted root issuer");
                }
            } else if (!certInChain.getParent().getSubject().equals(certInChain.getIssuer())) {
                throw new CapBAC.Invalid(String.format("Issuer %s doesn't match subject of previous certificate in chain %s", certInChain.getIssuer(), certInChain.getParent().getSubject()));
            }
            if ((issuerKey = this.pubs.get(certInChain.getIssuer())) == null) {
                throw new CapBAC.BadID(String.format("Unknown issuer %s", certInChain.getIssuer()));
            }
            if (this.verify(certInChain.getProto().getPayload().toByteArray(), issuerKey, certInChain.getSignature())) continue;
            throw new CapBAC.BadSign(String.format("Bad sign by issuer %s", certInChain.getIssuer()));
        }
    }

    public void validate(CapBACInvocation inv, long now) throws CapBAC.Invalid, CapBAC.BadID, CapBAC.BadSign, CapBAC.Expired {
        if (inv.getExp() != 0L && inv.getExp() < now) {
            throw new CapBAC.Expired();
        }
        ECPublicKey invokerKey = this.pubs.get(inv.getInvoker());
        if (invokerKey == null) {
            throw new CapBAC.BadID(String.format("Unknown invoker %s", inv.getInvoker()));
        }
        if (!this.verify(inv.getProto().getPayload().toByteArray(), invokerKey, inv.getSignature())) {
            throw new CapBAC.BadSign("Bad sign by invoker");
        }
        if (!inv.getInvoker().equals(inv.getCertificate().getSubject())) {
            throw new CapBAC.Invalid("Invoker and certificate's subject don't match");
        }
        this.validate(inv.getCertificate(), now);
    }

    private boolean verify(byte[] data, ECPublicKey pk, byte[] signature) throws CapBAC.BadSign {
        try {
            Signature s = Signature.getInstance(CapBAC.ALG);
            s.initVerify(pk);
            s.update(data);
            return s.verify(signature);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CapBAC.SignatureError(e);
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new CapBAC.BadSign(e);
        }
    }
}

