/*
 * Decompiled with CFR 0.152.
 */
package io.xapix.capbac;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.xapix.capbac.CapBAC;
import io.xapix.capbac.CapBACHolder;
import io.xapix.capbac.CapBACProto;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.stream.StreamSupport;

public class CapBACCertificate
implements Iterable<CapBACCertificate> {
    final CapBACProto.Certificate proto;
    final CapBACProto.Certificate.Payload payload;

    public CapBACCertificate(byte[] data) throws CapBAC.Malformed {
        try {
            this.proto = CapBACProto.Certificate.parseFrom(data);
            this.payload = CapBACProto.Certificate.Payload.parseFrom(this.proto.getPayload());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CapBAC.Malformed(e);
        }
    }

    CapBACCertificate(CapBACProto.Certificate proto) {
        this.proto = proto;
        try {
            this.payload = CapBACProto.Certificate.Payload.parseFrom(proto.getPayload());
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    CapBACCertificate(Builder builder, CapBACHolder signer) {
        this(null, builder, signer);
    }

    CapBACCertificate(CapBACCertificate parent, Builder builder, CapBACHolder signer) {
        CapBACProto.Certificate.Payload.Builder payloadBuilder = CapBACProto.Certificate.Payload.newBuilder();
        payloadBuilder.setCapability(ByteString.copyFrom((byte[])builder.capability));
        payloadBuilder.setExpiration(builder.exp);
        payloadBuilder.setSubject(builder.subject.toString());
        payloadBuilder.setIssuer(signer.me.toString());
        if (parent != null) {
            payloadBuilder.setParent(parent.proto);
        }
        CapBACProto.Certificate.Payload payload = payloadBuilder.build();
        ByteString payloadBytes = payload.toByteString();
        CapBACProto.Certificate.Builder protoBuilder = CapBACProto.Certificate.newBuilder();
        protoBuilder.setPayload(payloadBytes);
        protoBuilder.setSignature(ByteString.copyFrom((byte[])signer.sign(payloadBytes.toByteArray())));
        this.proto = protoBuilder.build();
        this.payload = payload;
    }

    public byte[] getCapability() {
        return this.payload.getCapability().toByteArray();
    }

    public byte[] getSignature() {
        return this.proto.getSignature().toByteArray();
    }

    public URL getIssuer() {
        try {
            return new URL(this.payload.getIssuer());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getSubject() {
        try {
            return new URL(this.payload.getSubject());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public long getExp() {
        return this.payload.getExpiration();
    }

    public CapBACCertificate getParent() {
        if (!this.payload.getParent().getPayload().isEmpty()) {
            return new CapBACCertificate(this.payload.getParent());
        }
        return null;
    }

    @Override
    public Iterator<CapBACCertificate> iterator() {
        return new Iterator<CapBACCertificate>(){
            private CapBACCertificate next;
            {
                this.next = CapBACCertificate.this;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public CapBACCertificate next() {
                CapBACCertificate prev = this.next;
                this.next = prev.getParent();
                return prev;
            }
        };
    }

    public CapBACCertificate getRoot() {
        return (CapBACCertificate)StreamSupport.stream(this.spliterator(), false).reduce((first, second) -> second).get();
    }

    public byte[] encode() {
        return this.proto.toByteArray();
    }

    public CapBACProto.Certificate getProto() {
        return this.proto;
    }

    public static class Builder {
        URL subject;
        byte[] capability;
        long exp = 0L;

        public Builder(URL subject, byte[] capability) {
            this.subject = subject;
            this.capability = capability;
        }

        public Builder withExp(long exp) {
            this.exp = exp;
            return this;
        }
    }
}

