/*
 * Decompiled with CFR 0.152.
 */
package io.xapix.flink;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.types.Row;

public class XapixCollector
extends RichSinkFunction<Row> {
    private final List<String> fields;
    private final String destination;
    private final String prefix;
    private transient PrintWriter output;
    private static final ObjectMapper mapper = new ObjectMapper().registerModule(new JavaTimeModule());

    public XapixCollector(List<String> fields, String destination, String prefix) {
        this.fields = fields;
        this.destination = destination;
        this.prefix = prefix;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.output = new PrintWriter(Files.createTempFile(Paths.get(this.destination, new String[0]), this.prefix, "", new FileAttribute[0]).toFile(), "UTF-8");
    }

    public void close() throws Exception {
        this.output.flush();
        this.output.close();
        super.close();
    }

    public synchronized void invoke(Row row) throws Exception {
        ObjectNode obj = mapper.createObjectNode();
        ObjectNode data = obj.putObject("row");
        for (int i = 0; i < this.fields.size(); ++i) {
            data.set(this.fields.get(i), mapper.convertValue(row.getField(i), JsonNode.class));
        }
        this.output.println(mapper.writeValueAsString(obj));
    }

    static {
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }
}

