/*
 * Decompiled with CFR 0.152.
 */
package io.xapix.flink;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.types.Row;

public class XapixMapInput
implements MapFunction<String, Row>,
ResultTypeQueryable<Row>,
Serializable {
    private final RowTypeInfo rowType;
    private static final ObjectMapper mapper = new ObjectMapper();

    public XapixMapInput(RowTypeInfo rowType) {
        this.rowType = rowType;
    }

    public Row map(String s) throws Exception {
        JsonNode root = mapper.readTree(s).get("row");
        if (root == null) {
            throw new BadValue("Message doesn't contain row fieild");
        }
        String[] fieldNames = this.rowType.getFieldNames();
        TypeInformation[] fieldTypes = this.rowType.getFieldTypes();
        Row row = new Row(fieldNames.length);
        for (int i = 0; i < fieldNames.length; ++i) {
            row.setField(i, this.jsonByRowType(fieldTypes[i], root.get(fieldNames[i])));
        }
        return row;
    }

    public TypeInformation<Row> getProducedType() {
        return this.rowType;
    }

    private Object jsonByRowType(TypeInformation<?> type, JsonNode node) throws BadValue {
        Class c = type.getTypeClass();
        if (node.isNull()) {
            return null;
        }
        if (c == Double.class && node.isNumber()) {
            return node.asDouble();
        }
        if (c == Long.class && node.canConvertToLong()) {
            return node.asLong();
        }
        if (c == String.class && node.isTextual()) {
            return node.asText();
        }
        if (c == Boolean.class && node.isBoolean()) {
            return node.asBoolean();
        }
        throw new BadValue("Value: " + node.toString() + " Type: " + type.toString());
    }

    static class BadValue
    extends Exception {
        public BadValue(String message) {
            super(message);
        }
    }
}

