/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class TxnOffsetCommitRequestData
implements ApiMessage {
    private String transactionalId;
    private String groupId;
    private long producerId;
    private short producerEpoch;
    private List<TxnOffsetCommitRequestTopic> topics;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public TxnOffsetCommitRequestData(Readable readable, short version) {
        this.topics = new ArrayList<TxnOffsetCommitRequestTopic>();
        this.read(readable, version);
    }

    public TxnOffsetCommitRequestData(Struct struct, short version) {
        this.topics = new ArrayList<TxnOffsetCommitRequestTopic>();
        this.fromStruct(struct, version);
    }

    public TxnOffsetCommitRequestData() {
        this.transactionalId = "";
        this.groupId = "";
        this.producerId = 0L;
        this.producerEpoch = 0;
        this.topics = new ArrayList<TxnOffsetCommitRequestTopic>();
    }

    @Override
    public short apiKey() {
        return 28;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable readable, short version) {
        this.transactionalId = readable.readNullableString();
        this.groupId = readable.readNullableString();
        this.producerId = readable.readLong();
        this.producerEpoch = readable.readShort();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topics.clear();
        } else {
            this.topics.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.topics.add(new TxnOffsetCommitRequestTopic(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeString(this.transactionalId);
        writable.writeString(this.groupId);
        writable.writeLong(this.producerId);
        writable.writeShort(this.producerEpoch);
        writable.writeInt(this.topics.size());
        for (TxnOffsetCommitRequestTopic element : this.topics) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.transactionalId = struct.getString("transactional_id");
        this.groupId = struct.getString("group_id");
        this.producerId = struct.getLong("producer_id");
        this.producerEpoch = struct.getShort("producer_epoch");
        Object[] nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<TxnOffsetCommitRequestTopic>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.topics.add(new TxnOffsetCommitRequestTopic((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("transactional_id", (Object)this.transactionalId);
        struct.set("group_id", (Object)this.groupId);
        struct.set("producer_id", (Object)this.producerId);
        struct.set("producer_epoch", (Object)this.producerEpoch);
        Struct[] nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (TxnOffsetCommitRequestTopic element : this.topics) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("topics", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 2;
        size += MessageUtil.serializedUtf8Length(this.transactionalId);
        size += 2;
        size += MessageUtil.serializedUtf8Length(this.groupId);
        size += 8;
        size += 2;
        size += 4;
        for (TxnOffsetCommitRequestTopic element : this.topics) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TxnOffsetCommitRequestData)) {
            return false;
        }
        TxnOffsetCommitRequestData other = (TxnOffsetCommitRequestData)obj;
        if (this.transactionalId == null ? other.transactionalId != null : !this.transactionalId.equals(other.transactionalId)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.producerId != other.producerId) {
            return false;
        }
        if (this.producerEpoch != other.producerEpoch) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.transactionalId == null ? 0 : this.transactionalId.hashCode());
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
        hashCode = 31 * hashCode + this.producerEpoch;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "TxnOffsetCommitRequestData(transactionalId='" + this.transactionalId + "', groupId='" + this.groupId + "', producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public String groupId() {
        return this.groupId;
    }

    public long producerId() {
        return this.producerId;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public List<TxnOffsetCommitRequestTopic> topics() {
        return this.topics;
    }

    public TxnOffsetCommitRequestData setTransactionalId(String v) {
        this.transactionalId = v;
        return this;
    }

    public TxnOffsetCommitRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public TxnOffsetCommitRequestData setProducerId(long v) {
        this.producerId = v;
        return this;
    }

    public TxnOffsetCommitRequestData setProducerEpoch(short v) {
        this.producerEpoch = v;
        return this;
    }

    public TxnOffsetCommitRequestData setTopics(List<TxnOffsetCommitRequestTopic> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("transactional_id", Type.STRING, "The ID of the transaction."), new Field("group_id", Type.STRING, "The ID of the group."), new Field("producer_id", Type.INT64, "The current producer ID in use by the transactional ID."), new Field("producer_epoch", Type.INT16, "The current epoch associated with the producer ID."), new Field("topics", new ArrayOf(TxnOffsetCommitRequestTopic.SCHEMA_0), "Each topic that we want to committ offsets for."));
        SCHEMA_2 = new Schema(new Field("transactional_id", Type.STRING, "The ID of the transaction."), new Field("group_id", Type.STRING, "The ID of the group."), new Field("producer_id", Type.INT64, "The current producer ID in use by the transactional ID."), new Field("producer_epoch", Type.INT16, "The current epoch associated with the producer ID."), new Field("topics", new ArrayOf(TxnOffsetCommitRequestTopic.SCHEMA_2), "Each topic that we want to committ offsets for."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }

    public static class TxnOffsetCommitRequestPartition
    implements Message {
        private int partitionIndex;
        private long committedOffset;
        private int committedLeaderEpoch;
        private String committedMetadata;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public TxnOffsetCommitRequestPartition(Readable readable, short version) {
            this.read(readable, version);
        }

        public TxnOffsetCommitRequestPartition(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public TxnOffsetCommitRequestPartition() {
            this.partitionIndex = 0;
            this.committedOffset = 0L;
            this.committedLeaderEpoch = -1;
            this.committedMetadata = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable readable, short version) {
            this.partitionIndex = readable.readInt();
            this.committedOffset = readable.readLong();
            this.committedLeaderEpoch = version >= 2 ? readable.readInt() : -1;
            this.committedMetadata = readable.readNullableString();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeInt(this.partitionIndex);
            writable.writeLong(this.committedOffset);
            if (version >= 2) {
                writable.writeInt(this.committedLeaderEpoch);
            }
            writable.writeNullableString(this.committedMetadata);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.partitionIndex = struct.getInt("partition_index");
            this.committedOffset = struct.getLong("committed_offset");
            this.committedLeaderEpoch = version >= 2 ? struct.getInt("committed_leader_epoch") : -1;
            this.committedMetadata = struct.getString("committed_metadata");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("committed_offset", (Object)this.committedOffset);
            if (version >= 2) {
                struct.set("committed_leader_epoch", (Object)this.committedLeaderEpoch);
            }
            struct.set("committed_metadata", (Object)this.committedMetadata);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 4;
            size += 8;
            if (version >= 2) {
                size += 4;
            }
            size += 2;
            if (this.committedMetadata != null) {
                size += MessageUtil.serializedUtf8Length(this.committedMetadata);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TxnOffsetCommitRequestPartition)) {
                return false;
            }
            TxnOffsetCommitRequestPartition other = (TxnOffsetCommitRequestPartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.committedOffset != other.committedOffset) {
                return false;
            }
            if (this.committedLeaderEpoch != other.committedLeaderEpoch) {
                return false;
            }
            return !(this.committedMetadata == null ? other.committedMetadata != null : !this.committedMetadata.equals(other.committedMetadata));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + ((int)(this.committedOffset >> 32) ^ (int)this.committedOffset);
            hashCode = 31 * hashCode + this.committedLeaderEpoch;
            hashCode = 31 * hashCode + (this.committedMetadata == null ? 0 : this.committedMetadata.hashCode());
            return hashCode;
        }

        public String toString() {
            return "TxnOffsetCommitRequestPartition(partitionIndex=" + this.partitionIndex + ", committedOffset=" + this.committedOffset + ", committedLeaderEpoch=" + this.committedLeaderEpoch + ", committedMetadata='" + this.committedMetadata + "')";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public long committedOffset() {
            return this.committedOffset;
        }

        public int committedLeaderEpoch() {
            return this.committedLeaderEpoch;
        }

        public String committedMetadata() {
            return this.committedMetadata;
        }

        public TxnOffsetCommitRequestPartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public TxnOffsetCommitRequestPartition setCommittedOffset(long v) {
            this.committedOffset = v;
            return this;
        }

        public TxnOffsetCommitRequestPartition setCommittedLeaderEpoch(int v) {
            this.committedLeaderEpoch = v;
            return this;
        }

        public TxnOffsetCommitRequestPartition setCommittedMetadata(String v) {
            this.committedMetadata = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The index of the partition within the topic."), new Field("committed_offset", Type.INT64, "The message offset to be committed."), new Field("committed_metadata", Type.NULLABLE_STRING, "Any associated metadata the client wants to keep."));
            SCHEMA_2 = new Schema(new Field("partition_index", Type.INT32, "The index of the partition within the topic."), new Field("committed_offset", Type.INT64, "The message offset to be committed."), new Field("committed_leader_epoch", Type.INT32, "The leader epoch of the last consumed record."), new Field("committed_metadata", Type.NULLABLE_STRING, "Any associated metadata the client wants to keep."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }

    public static class TxnOffsetCommitRequestTopic
    implements Message {
        private String name;
        private List<TxnOffsetCommitRequestPartition> partitions;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public TxnOffsetCommitRequestTopic(Readable readable, short version) {
            this.partitions = new ArrayList<TxnOffsetCommitRequestPartition>();
            this.read(readable, version);
        }

        public TxnOffsetCommitRequestTopic(Struct struct, short version) {
            this.partitions = new ArrayList<TxnOffsetCommitRequestPartition>();
            this.fromStruct(struct, version);
        }

        public TxnOffsetCommitRequestTopic() {
            this.name = "";
            this.partitions = new ArrayList<TxnOffsetCommitRequestPartition>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitions.clear();
            } else {
                this.partitions.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitions.add(new TxnOffsetCommitRequestPartition(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.partitions.size());
            for (TxnOffsetCommitRequestPartition element : this.partitions) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<TxnOffsetCommitRequestPartition>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitions.add(new TxnOffsetCommitRequestPartition((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Struct[] nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (TxnOffsetCommitRequestPartition element : this.partitions) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("partitions", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.name);
            size += 4;
            for (TxnOffsetCommitRequestPartition element : this.partitions) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TxnOffsetCommitRequestTopic)) {
                return false;
            }
            TxnOffsetCommitRequestTopic other = (TxnOffsetCommitRequestTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "TxnOffsetCommitRequestTopic(name='" + this.name + "', partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<TxnOffsetCommitRequestPartition> partitions() {
            return this.partitions;
        }

        public TxnOffsetCommitRequestTopic setName(String v) {
            this.name = v;
            return this;
        }

        public TxnOffsetCommitRequestTopic setPartitions(List<TxnOffsetCommitRequestPartition> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(TxnOffsetCommitRequestPartition.SCHEMA_0), "The partitions inside the topic that we want to committ offsets for."));
            SCHEMA_2 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(TxnOffsetCommitRequestPartition.SCHEMA_2), "The partitions inside the topic that we want to committ offsets for."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }
}

