/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiSet;
import org.apache.kafka.common.utils.ImplicitLinkedHashSet;

public class MetadataResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private MetadataResponseBrokerSet brokers;
    private String clusterId;
    private int controllerId;
    private MetadataResponseTopicSet topics;
    public static final Schema SCHEMA_0 = new Schema(new Field("brokers", new ArrayOf(MetadataResponseBroker.SCHEMA_0), "Each broker in the response."), new Field("topics", new ArrayOf(MetadataResponseTopic.SCHEMA_0), "Each topic in the response."));
    public static final Schema SCHEMA_1 = new Schema(new Field("brokers", new ArrayOf(MetadataResponseBroker.SCHEMA_1), "Each broker in the response."), new Field("controller_id", Type.INT32, "The ID of the controller broker."), new Field("topics", new ArrayOf(MetadataResponseTopic.SCHEMA_1), "Each topic in the response."));
    public static final Schema SCHEMA_2 = new Schema(new Field("brokers", new ArrayOf(MetadataResponseBroker.SCHEMA_1), "Each broker in the response."), new Field("cluster_id", Type.NULLABLE_STRING, "The cluster ID that responding broker belongs to."), new Field("controller_id", Type.INT32, "The ID of the controller broker."), new Field("topics", new ArrayOf(MetadataResponseTopic.SCHEMA_1), "Each topic in the response."));
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema[] SCHEMAS;

    public MetadataResponseData(Readable readable, short version) {
        this.brokers = new MetadataResponseBrokerSet(0);
        this.topics = new MetadataResponseTopicSet(0);
        this.read(readable, version);
    }

    public MetadataResponseData(Struct struct, short version) {
        this.brokers = new MetadataResponseBrokerSet(0);
        this.topics = new MetadataResponseTopicSet(0);
        this.fromStruct(struct, version);
    }

    public MetadataResponseData() {
        this.throttleTimeMs = 0;
        this.brokers = new MetadataResponseBrokerSet(0);
        this.clusterId = "";
        this.controllerId = -1;
        this.topics = new MetadataResponseTopicSet(0);
    }

    @Override
    public short apiKey() {
        return 3;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 7;
    }

    @Override
    public void read(Readable readable, short version) {
        int i;
        this.throttleTimeMs = version >= 3 ? readable.readInt() : 0;
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.brokers.clear(0);
        } else {
            this.brokers.clear(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                this.brokers.add(new MetadataResponseBroker(readable, version));
            }
        }
        this.clusterId = version >= 2 ? readable.readNullableString() : "";
        this.controllerId = version >= 1 ? readable.readInt() : -1;
        arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topics.clear(0);
        } else {
            this.topics.clear(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                this.topics.add(new MetadataResponseTopic(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        if (version >= 3) {
            writable.writeInt(this.throttleTimeMs);
        }
        writable.writeInt(this.brokers.size());
        for (Message element : this.brokers) {
            ((MetadataResponseBroker)element).write(writable, version);
        }
        if (version >= 2) {
            writable.writeNullableString(this.clusterId);
        }
        if (version >= 1) {
            writable.writeInt(this.controllerId);
        }
        writable.writeInt(this.topics.size());
        for (Message element : this.topics) {
            ((MetadataResponseTopic)element).write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = version >= 3 ? struct.getInt("throttle_time_ms") : 0;
        Object[] nestedObjects = struct.getArray("brokers");
        this.brokers = new MetadataResponseBrokerSet(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.brokers.add(new MetadataResponseBroker((Struct)nestedObject, version));
        }
        this.clusterId = version >= 2 ? struct.getString("cluster_id") : "";
        this.controllerId = version >= 1 ? struct.getInt("controller_id") : -1;
        nestedObjects = struct.getArray("topics");
        this.topics = new MetadataResponseTopicSet(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.topics.add(new MetadataResponseTopic((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        if (version >= 3) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        Struct[] nestedObjects = new Struct[this.brokers.size()];
        int i = 0;
        for (Message element : this.brokers) {
            nestedObjects[i++] = ((MetadataResponseBroker)element).toStruct(version);
        }
        struct.set("brokers", (Object)nestedObjects);
        if (version >= 2) {
            struct.set("cluster_id", (Object)this.clusterId);
        }
        if (version >= 1) {
            struct.set("controller_id", (Object)this.controllerId);
        }
        nestedObjects = new Struct[this.topics.size()];
        i = 0;
        for (Message element : this.topics) {
            nestedObjects[i++] = ((MetadataResponseTopic)element).toStruct(version);
        }
        struct.set("topics", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        if (version >= 3) {
            size += 4;
        } else if (this.throttleTimeMs != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default throttleTimeMs at version " + version);
        }
        size += 4;
        for (Message element : this.brokers) {
            size += ((MetadataResponseBroker)element).size(version);
        }
        if (version >= 2) {
            size += 2;
            if (this.clusterId != null) {
                size += MessageUtil.serializedUtf8Length(this.clusterId);
            }
        }
        if (version >= 1) {
            size += 4;
        }
        size += 4;
        for (Message element : this.topics) {
            size += ((MetadataResponseTopic)element).size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MetadataResponseData)) {
            return false;
        }
        MetadataResponseData other = (MetadataResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.brokers == null ? other.brokers != null : !this.brokers.equals(other.brokers)) {
            return false;
        }
        if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
            return false;
        }
        if (this.controllerId != other.controllerId) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.brokers == null ? 0 : this.brokers.hashCode());
        hashCode = 31 * hashCode + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        hashCode = 31 * hashCode + this.controllerId;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "MetadataResponseData(throttleTimeMs=" + this.throttleTimeMs + ", brokers=" + MessageUtil.deepToString(this.brokers.iterator()) + ", clusterId='" + this.clusterId + "', controllerId=" + this.controllerId + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public MetadataResponseBrokerSet brokers() {
        return this.brokers;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public MetadataResponseTopicSet topics() {
        return this.topics;
    }

    public MetadataResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public MetadataResponseData setBrokers(MetadataResponseBrokerSet v) {
        this.brokers = v;
        return this;
    }

    public MetadataResponseData setClusterId(String v) {
        this.clusterId = v;
        return this;
    }

    public MetadataResponseData setControllerId(int v) {
        this.controllerId = v;
        return this;
    }

    public MetadataResponseData setTopics(MetadataResponseTopicSet v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_4 = SCHEMA_3 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("brokers", new ArrayOf(MetadataResponseBroker.SCHEMA_1), "Each broker in the response."), new Field("cluster_id", Type.NULLABLE_STRING, "The cluster ID that responding broker belongs to."), new Field("controller_id", Type.INT32, "The ID of the controller broker."), new Field("topics", new ArrayOf(MetadataResponseTopic.SCHEMA_1), "Each topic in the response."));
        SCHEMA_6 = SCHEMA_5 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("brokers", new ArrayOf(MetadataResponseBroker.SCHEMA_1), "Each broker in the response."), new Field("cluster_id", Type.NULLABLE_STRING, "The cluster ID that responding broker belongs to."), new Field("controller_id", Type.INT32, "The ID of the controller broker."), new Field("topics", new ArrayOf(MetadataResponseTopic.SCHEMA_5), "Each topic in the response."));
        SCHEMA_7 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("brokers", new ArrayOf(MetadataResponseBroker.SCHEMA_1), "Each broker in the response."), new Field("cluster_id", Type.NULLABLE_STRING, "The cluster ID that responding broker belongs to."), new Field("controller_id", Type.INT32, "The ID of the controller broker."), new Field("topics", new ArrayOf(MetadataResponseTopic.SCHEMA_7), "Each topic in the response."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
    }

    public static class MetadataResponseTopicSet
    extends ImplicitLinkedHashMultiSet<MetadataResponseTopic> {
        public MetadataResponseTopicSet() {
        }

        public MetadataResponseTopicSet(int expectedNumElements) {
            super(expectedNumElements);
        }

        public MetadataResponseTopicSet(Iterator<MetadataResponseTopic> iterator) {
            super(iterator);
        }

        @Override
        public MetadataResponseTopic find(String name) {
            MetadataResponseTopic key = new MetadataResponseTopic();
            key.setName(name);
            return this.find(key);
        }

        @Override
        public List<MetadataResponseTopic> findAll(String name) {
            MetadataResponseTopic key = new MetadataResponseTopic();
            key.setName(name);
            return this.findAll(key);
        }
    }

    public static class MetadataResponsePartition
    implements Message {
        private short errorCode;
        private int partitionIndex;
        private int leaderId;
        private int leaderEpoch;
        private List<Integer> replicaNodes;
        private List<Integer> isrNodes;
        private List<Integer> offlineReplicas;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;

        public MetadataResponsePartition(Readable readable, short version) {
            this.replicaNodes = new ArrayList<Integer>();
            this.isrNodes = new ArrayList<Integer>();
            this.offlineReplicas = new ArrayList<Integer>();
            this.read(readable, version);
        }

        public MetadataResponsePartition(Struct struct, short version) {
            this.replicaNodes = new ArrayList<Integer>();
            this.isrNodes = new ArrayList<Integer>();
            this.offlineReplicas = new ArrayList<Integer>();
            this.fromStruct(struct, version);
        }

        public MetadataResponsePartition() {
            this.errorCode = 0;
            this.partitionIndex = 0;
            this.leaderId = 0;
            this.leaderEpoch = -1;
            this.replicaNodes = new ArrayList<Integer>();
            this.isrNodes = new ArrayList<Integer>();
            this.offlineReplicas = new ArrayList<Integer>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 7;
        }

        @Override
        public void read(Readable readable, short version) {
            int i;
            this.errorCode = readable.readShort();
            this.partitionIndex = readable.readInt();
            this.leaderId = readable.readInt();
            this.leaderEpoch = version >= 7 ? readable.readInt() : -1;
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.replicaNodes.clear();
            } else {
                this.replicaNodes.clear();
                for (i = 0; i < arrayLength; ++i) {
                    this.replicaNodes.add(readable.readInt());
                }
            }
            arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.isrNodes.clear();
            } else {
                this.isrNodes.clear();
                for (i = 0; i < arrayLength; ++i) {
                    this.isrNodes.add(readable.readInt());
                }
            }
            if (version >= 5) {
                arrayLength = readable.readInt();
                if (arrayLength < 0) {
                    this.offlineReplicas.clear();
                } else {
                    this.offlineReplicas.clear();
                    for (i = 0; i < arrayLength; ++i) {
                        this.offlineReplicas.add(readable.readInt());
                    }
                }
            } else {
                this.offlineReplicas = new ArrayList<Integer>();
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeShort(this.errorCode);
            writable.writeInt(this.partitionIndex);
            writable.writeInt(this.leaderId);
            if (version >= 7) {
                writable.writeInt(this.leaderEpoch);
            }
            writable.writeInt(this.replicaNodes.size());
            for (Integer element : this.replicaNodes) {
                writable.writeInt(element);
            }
            writable.writeInt(this.isrNodes.size());
            for (Integer element : this.isrNodes) {
                writable.writeInt(element);
            }
            if (version >= 5) {
                writable.writeInt(this.offlineReplicas.size());
                for (Integer element : this.offlineReplicas) {
                    writable.writeInt(element);
                }
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.errorCode = struct.getShort("error_code");
            this.partitionIndex = struct.getInt("partition_index");
            this.leaderId = struct.getInt("leader_id");
            this.leaderEpoch = version >= 7 ? struct.getInt("leader_epoch") : -1;
            Object[] nestedObjects = struct.getArray("replica_nodes");
            this.replicaNodes = new ArrayList<Integer>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.replicaNodes.add((Integer)nestedObject);
            }
            nestedObjects = struct.getArray("isr_nodes");
            this.isrNodes = new ArrayList<Integer>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.isrNodes.add((Integer)nestedObject);
            }
            if (version >= 5) {
                nestedObjects = struct.getArray("offline_replicas");
                this.offlineReplicas = new ArrayList<Integer>(nestedObjects.length);
                for (Object nestedObject : nestedObjects) {
                    this.offlineReplicas.add((Integer)nestedObject);
                }
            } else {
                this.offlineReplicas = new ArrayList<Integer>();
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("leader_id", (Object)this.leaderId);
            if (version >= 7) {
                struct.set("leader_epoch", (Object)this.leaderEpoch);
            }
            Integer[] nestedObjects = new Integer[this.replicaNodes.size()];
            int i = 0;
            for (Integer element : this.replicaNodes) {
                nestedObjects[i++] = element;
            }
            struct.set("replica_nodes", (Object)nestedObjects);
            nestedObjects = new Integer[this.isrNodes.size()];
            i = 0;
            for (Integer element : this.isrNodes) {
                nestedObjects[i++] = element;
            }
            struct.set("isr_nodes", (Object)nestedObjects);
            if (version >= 5) {
                nestedObjects = new Integer[this.offlineReplicas.size()];
                i = 0;
                for (Integer element : this.offlineReplicas) {
                    nestedObjects[i++] = element;
                }
                struct.set("offline_replicas", (Object)nestedObjects);
            }
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += 4;
            size += 4;
            if (version >= 7) {
                size += 4;
            }
            size += 4;
            size += this.replicaNodes.size() * 4;
            size += 4;
            size += this.isrNodes.size() * 4;
            if (version >= 5) {
                size += 4;
                size += this.offlineReplicas.size() * 4;
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MetadataResponsePartition)) {
                return false;
            }
            MetadataResponsePartition other = (MetadataResponsePartition)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.leaderId != other.leaderId) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (this.replicaNodes == null ? other.replicaNodes != null : !this.replicaNodes.equals(other.replicaNodes)) {
                return false;
            }
            if (this.isrNodes == null ? other.isrNodes != null : !this.isrNodes.equals(other.isrNodes)) {
                return false;
            }
            return !(this.offlineReplicas == null ? other.offlineReplicas != null : !this.offlineReplicas.equals(other.offlineReplicas));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.leaderId;
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + (this.replicaNodes == null ? 0 : this.replicaNodes.hashCode());
            hashCode = 31 * hashCode + (this.isrNodes == null ? 0 : this.isrNodes.hashCode());
            hashCode = 31 * hashCode + (this.offlineReplicas == null ? 0 : this.offlineReplicas.hashCode());
            return hashCode;
        }

        public String toString() {
            return "MetadataResponsePartition(errorCode=" + this.errorCode + ", partitionIndex=" + this.partitionIndex + ", leaderId=" + this.leaderId + ", leaderEpoch=" + this.leaderEpoch + ", replicaNodes=" + MessageUtil.deepToString(this.replicaNodes.iterator()) + ", isrNodes=" + MessageUtil.deepToString(this.isrNodes.iterator()) + ", offlineReplicas=" + MessageUtil.deepToString(this.offlineReplicas.iterator()) + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int leaderId() {
            return this.leaderId;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public List<Integer> replicaNodes() {
            return this.replicaNodes;
        }

        public List<Integer> isrNodes() {
            return this.isrNodes;
        }

        public List<Integer> offlineReplicas() {
            return this.offlineReplicas;
        }

        public MetadataResponsePartition setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public MetadataResponsePartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public MetadataResponsePartition setLeaderId(int v) {
            this.leaderId = v;
            return this;
        }

        public MetadataResponsePartition setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public MetadataResponsePartition setReplicaNodes(List<Integer> v) {
            this.replicaNodes = v;
            return this;
        }

        public MetadataResponsePartition setIsrNodes(List<Integer> v) {
            this.isrNodes = v;
            return this;
        }

        public MetadataResponsePartition setOfflineReplicas(List<Integer> v) {
            this.offlineReplicas = v;
            return this;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The partition error, or 0 if there was no error."), new Field("partition_index", Type.INT32, "The partition index."), new Field("leader_id", Type.INT32, "The ID of the leader broker."), new Field("replica_nodes", new ArrayOf(Type.INT32), "The set of all nodes that host this partition."), new Field("isr_nodes", new ArrayOf(Type.INT32), "The set of nodes that are in sync with the leader for this partition.")))));
            SCHEMA_6 = SCHEMA_5 = new Schema(new Field("error_code", Type.INT16, "The partition error, or 0 if there was no error."), new Field("partition_index", Type.INT32, "The partition index."), new Field("leader_id", Type.INT32, "The ID of the leader broker."), new Field("replica_nodes", new ArrayOf(Type.INT32), "The set of all nodes that host this partition."), new Field("isr_nodes", new ArrayOf(Type.INT32), "The set of nodes that are in sync with the leader for this partition."), new Field("offline_replicas", new ArrayOf(Type.INT32), "The set of offline replicas of this partition."));
            SCHEMA_7 = new Schema(new Field("error_code", Type.INT16, "The partition error, or 0 if there was no error."), new Field("partition_index", Type.INT32, "The partition index."), new Field("leader_id", Type.INT32, "The ID of the leader broker."), new Field("leader_epoch", Type.INT32, "The leader epoch of this partition."), new Field("replica_nodes", new ArrayOf(Type.INT32), "The set of all nodes that host this partition."), new Field("isr_nodes", new ArrayOf(Type.INT32), "The set of nodes that are in sync with the leader for this partition."), new Field("offline_replicas", new ArrayOf(Type.INT32), "The set of offline replicas of this partition."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }

    public static class MetadataResponseTopic
    implements Message,
    ImplicitLinkedHashSet.Element {
        private short errorCode;
        private String name;
        private boolean isInternal;
        private List<MetadataResponsePartition> partitions;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The topic error, or 0 if there was no error."), new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(MetadataResponsePartition.SCHEMA_0), "Each partition in the topic."));
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;

        public MetadataResponseTopic(Readable readable, short version) {
            this.partitions = new ArrayList<MetadataResponsePartition>();
            this.read(readable, version);
        }

        public MetadataResponseTopic(Struct struct, short version) {
            this.partitions = new ArrayList<MetadataResponsePartition>();
            this.fromStruct(struct, version);
        }

        public MetadataResponseTopic() {
            this.errorCode = 0;
            this.name = "";
            this.isInternal = false;
            this.partitions = new ArrayList<MetadataResponsePartition>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 7;
        }

        @Override
        public void read(Readable readable, short version) {
            this.errorCode = readable.readShort();
            this.name = readable.readNullableString();
            this.isInternal = version >= 1 ? readable.readByte() != 0 : false;
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitions.clear();
            } else {
                this.partitions.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitions.add(new MetadataResponsePartition(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeShort(this.errorCode);
            writable.writeString(this.name);
            if (version >= 1) {
                writable.writeByte(this.isInternal ? (byte)1 : 0);
            }
            writable.writeInt(this.partitions.size());
            for (MetadataResponsePartition element : this.partitions) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.errorCode = struct.getShort("error_code");
            this.name = struct.getString("name");
            this.isInternal = version >= 1 ? struct.getBoolean("is_internal") : false;
            Object[] nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<MetadataResponsePartition>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitions.add(new MetadataResponsePartition((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("name", (Object)this.name);
            if (version >= 1) {
                struct.set("is_internal", (Object)this.isInternal);
            }
            Struct[] nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (MetadataResponsePartition element : this.partitions) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("partitions", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.name);
            if (version >= 1) {
                ++size;
            }
            size += 4;
            for (MetadataResponsePartition element : this.partitions) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MetadataResponseTopic)) {
                return false;
            }
            MetadataResponseTopic other = (MetadataResponseTopic)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public String toString() {
            return "MetadataResponseTopic(errorCode=" + this.errorCode + ", name='" + this.name + "', isInternal=" + (this.isInternal ? "true" : "false") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String name() {
            return this.name;
        }

        public boolean isInternal() {
            return this.isInternal;
        }

        public List<MetadataResponsePartition> partitions() {
            return this.partitions;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        public MetadataResponseTopic setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public MetadataResponseTopic setName(String v) {
            this.name = v;
            return this;
        }

        public MetadataResponseTopic setIsInternal(boolean v) {
            this.isInternal = v;
            return this;
        }

        public MetadataResponseTopic setPartitions(List<MetadataResponsePartition> v) {
            this.partitions = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("error_code", Type.INT16, "The topic error, or 0 if there was no error."), new Field("name", Type.STRING, "The topic name."), new Field("is_internal", Type.BOOLEAN, "True if the topic is internal."), new Field("partitions", new ArrayOf(MetadataResponsePartition.SCHEMA_0), "Each partition in the topic."))));
            SCHEMA_6 = SCHEMA_5 = new Schema(new Field("error_code", Type.INT16, "The topic error, or 0 if there was no error."), new Field("name", Type.STRING, "The topic name."), new Field("is_internal", Type.BOOLEAN, "True if the topic is internal."), new Field("partitions", new ArrayOf(MetadataResponsePartition.SCHEMA_5), "Each partition in the topic."));
            SCHEMA_7 = new Schema(new Field("error_code", Type.INT16, "The topic error, or 0 if there was no error."), new Field("name", Type.STRING, "The topic name."), new Field("is_internal", Type.BOOLEAN, "True if the topic is internal."), new Field("partitions", new ArrayOf(MetadataResponsePartition.SCHEMA_7), "Each partition in the topic."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }

    public static class MetadataResponseBrokerSet
    extends ImplicitLinkedHashMultiSet<MetadataResponseBroker> {
        public MetadataResponseBrokerSet() {
        }

        public MetadataResponseBrokerSet(int expectedNumElements) {
            super(expectedNumElements);
        }

        public MetadataResponseBrokerSet(Iterator<MetadataResponseBroker> iterator) {
            super(iterator);
        }

        @Override
        public MetadataResponseBroker find(int nodeId) {
            MetadataResponseBroker key = new MetadataResponseBroker();
            key.setNodeId(nodeId);
            return this.find(key);
        }

        @Override
        public List<MetadataResponseBroker> findAll(int nodeId) {
            MetadataResponseBroker key = new MetadataResponseBroker();
            key.setNodeId(nodeId);
            return this.findAll(key);
        }
    }

    public static class MetadataResponseBroker
    implements Message,
    ImplicitLinkedHashSet.Element {
        private int nodeId;
        private String host;
        private int port;
        private String rack;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field("node_id", Type.INT32, "The broker ID."), new Field("host", Type.STRING, "The broker hostname."), new Field("port", Type.INT32, "The broker port."));
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;

        public MetadataResponseBroker(Readable readable, short version) {
            this.read(readable, version);
        }

        public MetadataResponseBroker(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public MetadataResponseBroker() {
            this.nodeId = 0;
            this.host = "";
            this.port = 0;
            this.rack = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 7;
        }

        @Override
        public void read(Readable readable, short version) {
            this.nodeId = readable.readInt();
            this.host = readable.readNullableString();
            this.port = readable.readInt();
            this.rack = version >= 1 ? readable.readNullableString() : "";
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeInt(this.nodeId);
            writable.writeString(this.host);
            writable.writeInt(this.port);
            if (version >= 1) {
                writable.writeNullableString(this.rack);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.nodeId = struct.getInt("node_id");
            this.host = struct.getString("host");
            this.port = struct.getInt("port");
            this.rack = version >= 1 ? struct.getString("rack") : "";
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("node_id", (Object)this.nodeId);
            struct.set("host", (Object)this.host);
            struct.set("port", (Object)this.port);
            if (version >= 1) {
                struct.set("rack", (Object)this.rack);
            }
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 4;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.host);
            size += 4;
            if (version >= 1) {
                size += 2;
                if (this.rack != null) {
                    size += MessageUtil.serializedUtf8Length(this.rack);
                }
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MetadataResponseBroker)) {
                return false;
            }
            MetadataResponseBroker other = (MetadataResponseBroker)obj;
            return this.nodeId == other.nodeId;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.nodeId;
            return hashCode;
        }

        public String toString() {
            return "MetadataResponseBroker(nodeId=" + this.nodeId + ", host='" + this.host + "', port=" + this.port + ", rack='" + this.rack + "')";
        }

        public int nodeId() {
            return this.nodeId;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public String rack() {
            return this.rack;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        public MetadataResponseBroker setNodeId(int v) {
            this.nodeId = v;
            return this;
        }

        public MetadataResponseBroker setHost(String v) {
            this.host = v;
            return this;
        }

        public MetadataResponseBroker setPort(int v) {
            this.port = v;
            return this;
        }

        public MetadataResponseBroker setRack(String v) {
            this.rack = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("node_id", Type.INT32, "The broker ID."), new Field("host", Type.STRING, "The broker hostname."), new Field("port", Type.INT32, "The broker port."), new Field("rack", Type.NULLABLE_STRING, "The rack of the broker, or null if it has not been assigned to a rack.")))))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }
}

