(ns volga-firebird.specs.soap-unit
  (:require [clojure.spec.alpha :as s]
            [spec-tools.spec :as spec]
            [volga-firebird.specs.parameter :as parameter]
            [volga-firebird.specs.common :as common]))

(s/def ::type #{"SOAP"})

(s/def ::http-method #{"POST"})

(s/def ::timeout spec/integer?)

(s/def ::cache-expiration spec/integer?)

(s/def ::range (s/coll-of spec/integer?
                          :into []
                          :min-count 2
                          :max-count 2))

(s/def ::valid-response-codes (s/coll-of (s/or :integer spec/integer?
                                               :range ::range)
                                         :into []))

(s/def ::soap-version #{"1.1" "1.2"})

(s/def ::input-xml spec/string?)

(s/def ::output-xml spec/string?)

(s/def ::soap-envelopes (s/keys :req-un [::input-xml
                                         ::output-xml]))

(s/def ::config (s/keys :req-un [::type
                                 ::common/url
                                 ::parameter/parameters
                                 ::soap-version
                                 ::soap-envelopes]
                        :opt-un [::timeout
                                 ::cache-expiration
                                 ::valid-response-codes]))
