(ns volga-firebird.unit.response
  (:require [cheshire.core :as cheshire]
            [volga-firebird.unit :as unit]))

(defn- wrap-response [response]
  (let [result (->> response
                   (filter (fn [[k v]]
                             (not (or (= :context k)
                                      (instance? Throwable v)))))
                   (into {}))
        errors (->> response
                   (filter (fn [[_ v]]
                             (instance? Throwable v)))
                   (into {}))]
    (if (not-empty errors)
      {:status 502
       :body {:message "Some problems during pipeline exceution"
              :problems (->> errors
                            (map (fn [[k v]]
                                   [k (or (ex-data v) (.getMessage v))]))
                            (into {}))}}
      (get result (first (keys result))))))

(defn- log [response context]
  (let [response-body (cheshire/generate-string (or (:body response) ""))]
    (println
     (cheshire/generate-string
      (-> (:request context)
          (update :response_time #(- (System/currentTimeMillis) %))
          (assoc :response_body response-body)
          (assoc :response_content_length (count response-body))
          (assoc :response_status (:status response)))))))

(defmethod unit/unit->unit-fn :response [_]
  (fn [{:keys [context] :as request}]
    (let [response (wrap-response request)]
      (log response context)
      response)))
